/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.crypto;

import java.io.InputStream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.record.BiffHeaderInput;
import org.apache.poi.hssf.record.crypto.Biff8Cipher;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.record.crypto.Biff8RC4;
import org.apache.poi.hssf.record.crypto.Biff8RC4Key;
import org.apache.poi.hssf.record.crypto.Biff8XOR;
import org.apache.poi.hssf.record.crypto.Biff8XORKey;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianInputStream;

public final class Biff8DecryptingStream
implements BiffHeaderInput,
LittleEndianInput {
    private final LittleEndianInput _le;
    private final Biff8Cipher _cipher;

    public Biff8DecryptingStream(InputStream in2, int initialOffset, Biff8EncryptionKey key) {
        if (key instanceof Biff8RC4Key) {
            this._cipher = new Biff8RC4(initialOffset, (Biff8RC4Key)key);
        } else if (key instanceof Biff8XORKey) {
            this._cipher = new Biff8XOR(initialOffset, (Biff8XORKey)key);
        } else {
            throw new EncryptedDocumentException("Crypto API not supported yet.");
        }
        this._le = in2 instanceof LittleEndianInput ? (LittleEndianInput)((Object)in2) : new LittleEndianInputStream(in2);
    }

    @Override
    public int available() {
        return this._le.available();
    }

    @Override
    public int readRecordSID() {
        int sid = this._le.readUShort();
        this._cipher.skipTwoBytes();
        this._cipher.startRecord(sid);
        return sid;
    }

    @Override
    public int readDataSize() {
        int dataSize = this._le.readUShort();
        this._cipher.skipTwoBytes();
        this._cipher.setNextRecordSize(dataSize);
        return dataSize;
    }

    @Override
    public double readDouble() {
        long valueLongBits = this.readLong();
        double result = Double.longBitsToDouble(valueLongBits);
        if (Double.isNaN(result)) {
            throw new RuntimeException("Did not expect to read NaN");
        }
        return result;
    }

    @Override
    public void readFully(byte[] buf) {
        this.readFully(buf, 0, buf.length);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) {
        this._le.readFully(buf, off, len);
        this._cipher.xor(buf, off, len);
    }

    @Override
    public int readUByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public byte readByte() {
        return (byte)this._cipher.xorByte(this._le.readUByte());
    }

    @Override
    public int readUShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public short readShort() {
        return (short)this._cipher.xorShort(this._le.readUShort());
    }

    @Override
    public int readInt() {
        return this._cipher.xorInt(this._le.readInt());
    }

    @Override
    public long readLong() {
        return this._cipher.xorLong(this._le.readLong());
    }
}

