/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.chart;

import java.util.Arrays;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class SeriesListRecord
extends StandardRecord {
    public static final short sid = 4118;
    private short[] field_1_seriesNumbers;

    public SeriesListRecord(short[] seriesNumbers) {
        this.field_1_seriesNumbers = seriesNumbers == null ? null : (short[])seriesNumbers.clone();
    }

    public SeriesListRecord(RecordInputStream in2) {
        int nItems = in2.readUShort();
        short[] ss = new short[nItems];
        for (int i2 = 0; i2 < nItems; ++i2) {
            ss[i2] = in2.readShort();
        }
        this.field_1_seriesNumbers = ss;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SERIESLIST]\n");
        buffer.append("    .seriesNumbers= ").append(" (").append(Arrays.toString(this.getSeriesNumbers())).append(" )");
        buffer.append("\n");
        buffer.append("[/SERIESLIST]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        int nItems = this.field_1_seriesNumbers.length;
        out.writeShort(nItems);
        for (int i2 = 0; i2 < nItems; ++i2) {
            out.writeShort(this.field_1_seriesNumbers[i2]);
        }
    }

    @Override
    protected int getDataSize() {
        return this.field_1_seriesNumbers.length * 2 + 2;
    }

    @Override
    public short getSid() {
        return 4118;
    }

    @Override
    public Object clone() {
        return new SeriesListRecord(this.field_1_seriesNumbers);
    }

    public short[] getSeriesNumbers() {
        return this.field_1_seriesNumbers;
    }
}

