/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.chart;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class ChartFRTInfoRecord
extends StandardRecord {
    public static final short sid = 2128;
    private short rt;
    private short grbitFrt;
    private byte verOriginator;
    private byte verWriter;
    private CFRTID[] rgCFRTID;

    public ChartFRTInfoRecord(RecordInputStream in2) {
        this.rt = in2.readShort();
        this.grbitFrt = in2.readShort();
        this.verOriginator = in2.readByte();
        this.verWriter = in2.readByte();
        int cCFRTID = in2.readShort();
        this.rgCFRTID = new CFRTID[cCFRTID];
        for (int i2 = 0; i2 < cCFRTID; ++i2) {
            this.rgCFRTID[i2] = new CFRTID(in2);
        }
    }

    @Override
    protected int getDataSize() {
        return 8 + this.rgCFRTID.length * 4;
    }

    @Override
    public short getSid() {
        return 2128;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.rt);
        out.writeShort(this.grbitFrt);
        out.writeByte(this.verOriginator);
        out.writeByte(this.verWriter);
        int nCFRTIDs = this.rgCFRTID.length;
        out.writeShort(nCFRTIDs);
        for (int i2 = 0; i2 < nCFRTIDs; ++i2) {
            this.rgCFRTID[i2].serialize(out);
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CHARTFRTINFO]\n");
        buffer.append("    .rt           =").append(HexDump.shortToHex(this.rt)).append('\n');
        buffer.append("    .grbitFrt     =").append(HexDump.shortToHex(this.grbitFrt)).append('\n');
        buffer.append("    .verOriginator=").append(HexDump.byteToHex(this.verOriginator)).append('\n');
        buffer.append("    .verWriter    =").append(HexDump.byteToHex(this.verOriginator)).append('\n');
        buffer.append("    .nCFRTIDs     =").append(HexDump.shortToHex(this.rgCFRTID.length)).append('\n');
        buffer.append("[/CHARTFRTINFO]\n");
        return buffer.toString();
    }

    private static final class CFRTID {
        public static final int ENCODED_SIZE = 4;
        private int rtFirst;
        private int rtLast;

        public CFRTID(LittleEndianInput in2) {
            this.rtFirst = in2.readShort();
            this.rtLast = in2.readShort();
        }

        public void serialize(LittleEndianOutput out) {
            out.writeShort(this.rtFirst);
            out.writeShort(this.rtLast);
        }
    }
}

