/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.cf;

import org.apache.poi.hssf.record.cf.ColorGradientThreshold;
import org.apache.poi.hssf.record.cf.Threshold;
import org.apache.poi.hssf.record.common.ExtendedColor;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class ColorGradientFormatting
implements Cloneable {
    private static POILogger log = POILogFactory.getLogger(ColorGradientFormatting.class);
    private byte options = 0;
    private ColorGradientThreshold[] thresholds;
    private ExtendedColor[] colors;
    private static BitField clamp = BitFieldFactory.getInstance(1);
    private static BitField background = BitFieldFactory.getInstance(2);

    public ColorGradientFormatting() {
        this.options = (byte)3;
        this.thresholds = new ColorGradientThreshold[3];
        this.colors = new ExtendedColor[3];
    }

    public ColorGradientFormatting(LittleEndianInput in2) {
        int i2;
        in2.readShort();
        in2.readByte();
        byte numI = in2.readByte();
        byte numG = in2.readByte();
        if (numI != numG) {
            log.log(5, new Object[]{"Inconsistent Color Gradient defintion, found " + numI + " vs " + numG + " entries"});
        }
        this.options = in2.readByte();
        this.thresholds = new ColorGradientThreshold[numI];
        for (i2 = 0; i2 < this.thresholds.length; ++i2) {
            this.thresholds[i2] = new ColorGradientThreshold(in2);
        }
        this.colors = new ExtendedColor[numG];
        for (i2 = 0; i2 < this.colors.length; ++i2) {
            in2.readDouble();
            this.colors[i2] = new ExtendedColor(in2);
        }
    }

    public int getNumControlPoints() {
        return this.thresholds.length;
    }

    public void setNumControlPoints(int num) {
        if (num != this.thresholds.length) {
            ColorGradientThreshold[] nt = new ColorGradientThreshold[num];
            ExtendedColor[] nc = new ExtendedColor[num];
            int copy = Math.min(this.thresholds.length, num);
            System.arraycopy(this.thresholds, 0, nt, 0, copy);
            System.arraycopy(this.colors, 0, nc, 0, copy);
            this.thresholds = nt;
            this.colors = nc;
            this.updateThresholdPositions();
        }
    }

    public ColorGradientThreshold[] getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(ColorGradientThreshold[] thresholds) {
        this.thresholds = thresholds == null ? null : (ColorGradientThreshold[])thresholds.clone();
        this.updateThresholdPositions();
    }

    public ExtendedColor[] getColors() {
        return this.colors;
    }

    public void setColors(ExtendedColor[] colors) {
        this.colors = colors == null ? null : (ExtendedColor[])colors.clone();
    }

    public boolean isClampToCurve() {
        return this.getOptionFlag(clamp);
    }

    public boolean isAppliesToBackground() {
        return this.getOptionFlag(background);
    }

    private boolean getOptionFlag(BitField field) {
        int value = field.getValue(this.options);
        return value != 0;
    }

    private void updateThresholdPositions() {
        double step = 1.0 / (double)(this.thresholds.length - 1);
        for (int i2 = 0; i2 < this.thresholds.length; ++i2) {
            this.thresholds[i2].setPosition(step * (double)i2);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("    [Color Gradient Formatting]\n");
        buffer.append("          .clamp     = ").append(this.isClampToCurve()).append("\n");
        buffer.append("          .background= ").append(this.isAppliesToBackground()).append("\n");
        for (ColorGradientThreshold colorGradientThreshold : this.thresholds) {
            buffer.append(colorGradientThreshold.toString());
        }
        for (Cloneable cloneable : this.colors) {
            buffer.append(((ExtendedColor)cloneable).toString());
        }
        buffer.append("    [/Color Gradient Formatting]\n");
        return buffer.toString();
    }

    public Object clone() {
        ColorGradientFormatting rec = new ColorGradientFormatting();
        rec.options = this.options;
        rec.thresholds = new ColorGradientThreshold[this.thresholds.length];
        rec.colors = new ExtendedColor[this.colors.length];
        System.arraycopy(this.thresholds, 0, rec.thresholds, 0, this.thresholds.length);
        System.arraycopy(this.colors, 0, rec.colors, 0, this.colors.length);
        return rec;
    }

    public int getDataLength() {
        int len = 6;
        for (ColorGradientThreshold colorGradientThreshold : this.thresholds) {
            len += ((Threshold)colorGradientThreshold).getDataLength();
        }
        for (Cloneable cloneable : this.colors) {
            len += ((ExtendedColor)cloneable).getDataLength();
            len += 8;
        }
        return len;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(0);
        out.writeByte(0);
        out.writeByte(this.thresholds.length);
        out.writeByte(this.thresholds.length);
        out.writeByte(this.options);
        for (ColorGradientThreshold t2 : this.thresholds) {
            t2.serialize(out);
        }
        double step = 1.0 / (double)(this.colors.length - 1);
        for (int i2 = 0; i2 < this.colors.length; ++i2) {
            out.writeDouble((double)i2 * step);
            ExtendedColor c2 = this.colors[i2];
            c2.serialize(out);
        }
    }
}

