/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class WindowProtectRecord
extends StandardRecord {
    public static final short sid = 25;
    private static final BitField settingsProtectedFlag = BitFieldFactory.getInstance(1);
    private int _options;

    public WindowProtectRecord(int options) {
        this._options = options;
    }

    public WindowProtectRecord(RecordInputStream in2) {
        this(in2.readUShort());
    }

    public WindowProtectRecord(boolean protect) {
        this(0);
        this.setProtect(protect);
    }

    public void setProtect(boolean protect) {
        this._options = settingsProtectedFlag.setBoolean(this._options, protect);
    }

    public boolean getProtect() {
        return settingsProtectedFlag.isSet(this._options);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WINDOWPROTECT]\n");
        buffer.append("    .options = ").append(HexDump.shortToHex(this._options)).append("\n");
        buffer.append("[/WINDOWPROTECT]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this._options);
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    @Override
    public short getSid() {
        return 25;
    }

    @Override
    public Object clone() {
        return new WindowProtectRecord(this._options);
    }
}

