/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellRecord;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.util.LittleEndianOutput;

public final class NumberRecord
extends CellRecord
implements Cloneable {
    public static final short sid = 515;
    private double field_4_value;

    public NumberRecord() {
    }

    public NumberRecord(RecordInputStream in2) {
        super(in2);
        this.field_4_value = in2.readDouble();
    }

    public void setValue(double value) {
        this.field_4_value = value;
    }

    public double getValue() {
        return this.field_4_value;
    }

    @Override
    protected String getRecordName() {
        return "NUMBER";
    }

    @Override
    protected void appendValueText(StringBuilder sb) {
        sb.append("  .value= ").append(NumberToTextConverter.toText(this.field_4_value));
    }

    @Override
    protected void serializeValue(LittleEndianOutput out) {
        out.writeDouble(this.getValue());
    }

    @Override
    protected int getValueDataSize() {
        return 8;
    }

    @Override
    public short getSid() {
        return 515;
    }

    @Override
    public NumberRecord clone() {
        NumberRecord rec = new NumberRecord();
        this.copyBaseFields(rec);
        rec.field_4_value = this.field_4_value;
        return rec;
    }
}

