/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.util.LittleEndianOutput;

public final class MergeCellsRecord
extends StandardRecord
implements Cloneable {
    public static final short sid = 229;
    private final CellRangeAddress[] _regions;
    private final int _startIndex;
    private final int _numberOfRegions;

    public MergeCellsRecord(CellRangeAddress[] regions, int startIndex, int numberOfRegions) {
        this._regions = regions;
        this._startIndex = startIndex;
        this._numberOfRegions = numberOfRegions;
    }

    public MergeCellsRecord(RecordInputStream in2) {
        int nRegions = in2.readUShort();
        CellRangeAddress[] cras = new CellRangeAddress[nRegions];
        for (int i2 = 0; i2 < nRegions; ++i2) {
            cras[i2] = new CellRangeAddress(in2);
        }
        this._numberOfRegions = nRegions;
        this._startIndex = 0;
        this._regions = cras;
    }

    public short getNumAreas() {
        return (short)this._numberOfRegions;
    }

    public CellRangeAddress getAreaAt(int index) {
        return this._regions[this._startIndex + index];
    }

    @Override
    protected int getDataSize() {
        return CellRangeAddressList.getEncodedSize(this._numberOfRegions);
    }

    @Override
    public short getSid() {
        return 229;
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        int nItems = this._numberOfRegions;
        out.writeShort(nItems);
        for (int i2 = 0; i2 < this._numberOfRegions; ++i2) {
            this._regions[this._startIndex + i2].serialize(out);
        }
    }

    @Override
    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[MERGEDCELLS]").append("\n");
        retval.append("     .numregions =").append(this.getNumAreas()).append("\n");
        for (int k2 = 0; k2 < this._numberOfRegions; ++k2) {
            CellRangeAddress r2 = this._regions[this._startIndex + k2];
            retval.append("     .rowfrom =").append(r2.getFirstRow()).append("\n");
            retval.append("     .rowto   =").append(r2.getLastRow()).append("\n");
            retval.append("     .colfrom =").append(r2.getFirstColumn()).append("\n");
            retval.append("     .colto   =").append(r2.getLastColumn()).append("\n");
        }
        retval.append("[MERGEDCELLS]").append("\n");
        return retval.toString();
    }

    @Override
    public MergeCellsRecord clone() {
        int nRegions = this._numberOfRegions;
        CellRangeAddress[] clonedRegions = new CellRangeAddress[nRegions];
        for (int i2 = 0; i2 < clonedRegions.length; ++i2) {
            clonedRegions[i2] = this._regions[this._startIndex + i2].copy();
        }
        return new MergeCellsRecord(clonedRegions, 0, nRegions);
    }
}

