/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class MMSRecord
extends StandardRecord {
    public static final short sid = 193;
    private byte field_1_addMenuCount;
    private byte field_2_delMenuCount;

    public MMSRecord() {
    }

    public MMSRecord(RecordInputStream in2) {
        if (in2.remaining() == 0) {
            return;
        }
        this.field_1_addMenuCount = in2.readByte();
        this.field_2_delMenuCount = in2.readByte();
    }

    public void setAddMenuCount(byte am2) {
        this.field_1_addMenuCount = am2;
    }

    public void setDelMenuCount(byte dm2) {
        this.field_2_delMenuCount = dm2;
    }

    public byte getAddMenuCount() {
        return this.field_1_addMenuCount;
    }

    public byte getDelMenuCount() {
        return this.field_2_delMenuCount;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[MMS]\n");
        buffer.append("    .addMenu        = ").append(Integer.toHexString(this.getAddMenuCount())).append("\n");
        buffer.append("    .delMenu        = ").append(Integer.toHexString(this.getDelMenuCount())).append("\n");
        buffer.append("[/MMS]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeByte(this.getAddMenuCount());
        out.writeByte(this.getDelMenuCount());
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    @Override
    public short getSid() {
        return 193;
    }
}

