/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class FormatRecord
extends StandardRecord
implements Cloneable {
    public static final short sid = 1054;
    private final int field_1_index_code;
    private final boolean field_3_hasMultibyte;
    private final String field_4_formatstring;

    private FormatRecord(FormatRecord other) {
        this.field_1_index_code = other.field_1_index_code;
        this.field_3_hasMultibyte = other.field_3_hasMultibyte;
        this.field_4_formatstring = other.field_4_formatstring;
    }

    public FormatRecord(int indexCode, String fs2) {
        this.field_1_index_code = indexCode;
        this.field_4_formatstring = fs2;
        this.field_3_hasMultibyte = StringUtil.hasMultibyte(fs2);
    }

    public FormatRecord(RecordInputStream in2) {
        this.field_1_index_code = in2.readShort();
        int field_3_unicode_len = in2.readUShort();
        this.field_3_hasMultibyte = (in2.readByte() & 1) != 0;
        this.field_4_formatstring = this.field_3_hasMultibyte ? in2.readUnicodeLEString(field_3_unicode_len) : in2.readCompressedUnicode(field_3_unicode_len);
    }

    public int getIndexCode() {
        return this.field_1_index_code;
    }

    public String getFormatString() {
        return this.field_4_formatstring;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FORMAT]\n");
        buffer.append("    .indexcode       = ").append(HexDump.shortToHex(this.getIndexCode())).append("\n");
        buffer.append("    .isUnicode       = ").append(this.field_3_hasMultibyte).append("\n");
        buffer.append("    .formatstring    = ").append(this.getFormatString()).append("\n");
        buffer.append("[/FORMAT]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        String formatString = this.getFormatString();
        out.writeShort(this.getIndexCode());
        out.writeShort(formatString.length());
        out.writeByte(this.field_3_hasMultibyte ? 1 : 0);
        if (this.field_3_hasMultibyte) {
            StringUtil.putUnicodeLE(formatString, out);
        } else {
            StringUtil.putCompressedUnicode(formatString, out);
        }
    }

    @Override
    protected int getDataSize() {
        return 5 + this.getFormatString().length() * (this.field_3_hasMultibyte ? 2 : 1);
    }

    @Override
    public short getSid() {
        return 1054;
    }

    @Override
    public FormatRecord clone() {
        return new FormatRecord(this);
    }
}

