/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;

@Deprecated
public class DrawingManager {
    EscherDggRecord dgg;
    Map<Short, EscherDgRecord> dgMap = new HashMap<Short, EscherDgRecord>();

    public DrawingManager(EscherDggRecord dgg) {
        this.dgg = dgg;
    }

    public EscherDgRecord createDgRecord() {
        EscherDgRecord dg2 = new EscherDgRecord();
        dg2.setRecordId((short)-4088);
        short dgId = this.findNewDrawingGroupId();
        dg2.setOptions((short)(dgId << 4));
        dg2.setNumShapes(0);
        dg2.setLastMSOSPID(-1);
        this.dgg.addCluster(dgId, 0);
        this.dgg.setDrawingsSaved(this.dgg.getDrawingsSaved() + 1);
        this.dgMap.put(dgId, dg2);
        return dg2;
    }

    public int allocateShapeId(short drawingGroupId) {
        EscherDgRecord dg2 = this.dgMap.get(drawingGroupId);
        int lastShapeId = dg2.getLastMSOSPID();
        int newShapeId = 0;
        if (lastShapeId % 1024 == 1023) {
            newShapeId = this.findFreeSPIDBlock();
            this.dgg.addCluster(drawingGroupId, 1);
        } else {
            for (int i2 = 0; i2 < this.dgg.getFileIdClusters().length; ++i2) {
                EscherDggRecord.FileIdCluster c2 = this.dgg.getFileIdClusters()[i2];
                if (c2.getDrawingGroupId() == drawingGroupId && c2.getNumShapeIdsUsed() != 1024) {
                    c2.incrementShapeId();
                }
                newShapeId = dg2.getLastMSOSPID() == -1 ? this.findFreeSPIDBlock() : dg2.getLastMSOSPID() + 1;
            }
        }
        this.dgg.setNumShapesSaved(this.dgg.getNumShapesSaved() + 1);
        if (newShapeId >= this.dgg.getShapeIdMax()) {
            this.dgg.setShapeIdMax(newShapeId + 1);
        }
        dg2.setLastMSOSPID(newShapeId);
        dg2.incrementShapeCount();
        return newShapeId;
    }

    short findNewDrawingGroupId() {
        short dgId = 1;
        while (this.drawingGroupExists(dgId)) {
            dgId = (short)(dgId + 1);
        }
        return dgId;
    }

    boolean drawingGroupExists(short dgId) {
        for (int i2 = 0; i2 < this.dgg.getFileIdClusters().length; ++i2) {
            if (this.dgg.getFileIdClusters()[i2].getDrawingGroupId() != dgId) continue;
            return true;
        }
        return false;
    }

    int findFreeSPIDBlock() {
        int max = this.dgg.getShapeIdMax();
        int next = (max / 1024 + 1) * 1024;
        return next;
    }

    public EscherDggRecord getDgg() {
        return this.dgg;
    }
}

