/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactoryInputStream;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest req, POIFSFileSystem fs2) throws IOException {
        this.processWorkbookEvents(req, fs2.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWorkbookEvents(HSSFRequest req, DirectoryNode dir) throws IOException {
        String name = null;
        Set<String> entryNames = dir.getEntryNames();
        for (String potentialName : InternalWorkbook.WORKBOOK_DIR_ENTRY_NAMES) {
            if (!entryNames.contains(potentialName)) continue;
            name = potentialName;
            break;
        }
        if (name == null) {
            name = InternalWorkbook.WORKBOOK_DIR_ENTRY_NAMES[0];
        }
        DocumentInputStream in2 = dir.createDocumentInputStream(name);
        try {
            this.processEvents(req, in2);
        }
        finally {
            ((InputStream)in2).close();
        }
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, POIFSFileSystem fs2) throws IOException, HSSFUserException {
        return this.abortableProcessWorkbookEvents(req, fs2.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short abortableProcessWorkbookEvents(HSSFRequest req, DirectoryNode dir) throws IOException, HSSFUserException {
        DocumentInputStream in2 = dir.createDocumentInputStream("Workbook");
        try {
            short s2 = this.abortableProcessEvents(req, in2);
            return s2;
        }
        finally {
            ((InputStream)in2).close();
        }
    }

    public void processEvents(HSSFRequest req, InputStream in2) {
        try {
            this.genericProcessEvents(req, in2);
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest req, InputStream in2) throws HSSFUserException {
        return this.genericProcessEvents(req, in2);
    }

    private short genericProcessEvents(HSSFRequest req, InputStream in2) throws HSSFUserException {
        Record r2;
        short userCode = 0;
        RecordFactoryInputStream recordStream = new RecordFactoryInputStream(in2, false);
        while ((r2 = recordStream.nextRecord()) != null && (userCode = req.processRecord(r2)) == 0) {
        }
        return userCode;
    }
}

