/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.NoSingleSectionException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.util.LittleEndian;

public abstract class SpecialPropertySet
extends MutablePropertySet {
    private final MutablePropertySet delegate;

    public abstract PropertyIDMap getPropertySetIDMap();

    public SpecialPropertySet(PropertySet ps) {
        this.delegate = new MutablePropertySet(ps);
    }

    public SpecialPropertySet(MutablePropertySet ps) {
        this.delegate = ps;
    }

    @Override
    public int getByteOrder() {
        return this.delegate.getByteOrder();
    }

    @Override
    public int getFormat() {
        return this.delegate.getFormat();
    }

    @Override
    public int getOSVersion() {
        return this.delegate.getOSVersion();
    }

    @Override
    public ClassID getClassID() {
        return this.delegate.getClassID();
    }

    @Override
    public int getSectionCount() {
        return this.delegate.getSectionCount();
    }

    @Override
    public List<Section> getSections() {
        return this.delegate.getSections();
    }

    @Override
    public boolean isSummaryInformation() {
        return this.delegate.isSummaryInformation();
    }

    @Override
    public boolean isDocumentSummaryInformation() {
        return this.delegate.isDocumentSummaryInformation();
    }

    @Override
    public Section getFirstSection() {
        return this.delegate.getFirstSection();
    }

    @Override
    public void addSection(Section section) {
        this.delegate.addSection(section);
    }

    @Override
    public void clearSections() {
        this.delegate.clearSections();
    }

    @Override
    public void setByteOrder(int byteOrder) {
        this.delegate.setByteOrder(byteOrder);
    }

    @Override
    public void setClassID(ClassID classID) {
        this.delegate.setClassID(classID);
    }

    @Override
    public void setFormat(int format) {
        this.delegate.setFormat(format);
    }

    @Override
    public void setOSVersion(int osVersion) {
        this.delegate.setOSVersion(osVersion);
    }

    @Override
    public InputStream toInputStream() throws IOException, WritingNotSupportedException {
        return this.delegate.toInputStream();
    }

    @Override
    public void write(DirectoryEntry dir, String name) throws WritingNotSupportedException, IOException {
        this.delegate.write(dir, name);
    }

    @Override
    public void write(OutputStream out) throws WritingNotSupportedException, IOException {
        this.delegate.write(out);
    }

    @Override
    public boolean equals(Object o2) {
        return this.delegate.equals(o2);
    }

    @Override
    public Property[] getProperties() throws NoSingleSectionException {
        return this.delegate.getProperties();
    }

    @Override
    protected Object getProperty(int id2) throws NoSingleSectionException {
        return this.delegate.getProperty(id2);
    }

    @Override
    protected boolean getPropertyBooleanValue(int id2) throws NoSingleSectionException {
        return this.delegate.getPropertyBooleanValue(id2);
    }

    @Override
    protected int getPropertyIntValue(int id2) throws NoSingleSectionException {
        return this.delegate.getPropertyIntValue(id2);
    }

    protected String getPropertyStringValue(int propertyId) {
        Object propertyValue = this.getProperty(propertyId);
        return SpecialPropertySet.getPropertyStringValue(propertyValue);
    }

    protected static String getPropertyStringValue(Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof String) {
            return (String)propertyValue;
        }
        if (propertyValue instanceof byte[]) {
            byte[] b2 = (byte[])propertyValue;
            if (b2.length == 0) {
                return "";
            }
            if (b2.length == 1) {
                return Byte.toString(b2[0]);
            }
            if (b2.length == 2) {
                return Integer.toString(LittleEndian.getUShort(b2));
            }
            if (b2.length == 4) {
                return Long.toString(LittleEndian.getUInt(b2));
            }
            return new String(b2, Charset.forName("ASCII"));
        }
        return propertyValue.toString();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean wasNull() throws NoSingleSectionException {
        return this.delegate.wasNull();
    }
}

