/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.MutableProperty;

public class CustomProperties
extends HashMap<Object, CustomProperty> {
    private final Map<Long, String> dictionaryIDToName = new HashMap<Long, String>();
    private final Map<String, Long> dictionaryNameToID = new HashMap<String, Long>();
    private boolean isPure = true;

    @Override
    public CustomProperty put(String name, CustomProperty cp2) {
        if (name == null) {
            this.isPure = false;
            return null;
        }
        if (!name.equals(cp2.getName())) {
            throw new IllegalArgumentException("Parameter \"name\" (" + name + ") and custom property's name (" + cp2.getName() + ") do not match.");
        }
        Long idKey = cp2.getID();
        Long oldID = this.dictionaryNameToID.get(name);
        this.dictionaryIDToName.remove(oldID);
        this.dictionaryNameToID.put(name, idKey);
        this.dictionaryIDToName.put(idKey, name);
        CustomProperty oldCp = (CustomProperty)super.remove(oldID);
        super.put(idKey, cp2);
        return oldCp;
    }

    private Object put(CustomProperty customProperty) throws ClassCastException {
        String name = customProperty.getName();
        Long oldId = this.dictionaryNameToID.get(name);
        if (oldId != null) {
            customProperty.setID(oldId);
        } else {
            long max = 1L;
            for (Long long1 : this.dictionaryIDToName.keySet()) {
                long id2 = long1;
                if (id2 <= max) continue;
                max = id2;
            }
            customProperty.setID(max + 1L);
        }
        return this.put(name, customProperty);
    }

    public Object remove(String name) {
        Long id2 = this.dictionaryNameToID.get(name);
        if (id2 == null) {
            return null;
        }
        this.dictionaryIDToName.remove(id2);
        this.dictionaryNameToID.remove(name);
        return super.remove(id2);
    }

    @Override
    public Object put(String name, String value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(31L);
        p2.setValue(value);
        CustomProperty cp2 = new CustomProperty(p2, name);
        return this.put(cp2);
    }

    @Override
    public Object put(String name, Long value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(20L);
        p2.setValue(value);
        CustomProperty cp2 = new CustomProperty(p2, name);
        return this.put(cp2);
    }

    @Override
    public Object put(String name, Double value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(5L);
        p2.setValue(value);
        CustomProperty cp2 = new CustomProperty(p2, name);
        return this.put(cp2);
    }

    @Override
    public Object put(String name, Integer value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(3L);
        p2.setValue(value);
        CustomProperty cp2 = new CustomProperty(p2, name);
        return this.put(cp2);
    }

    @Override
    public Object put(String name, Boolean value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(11L);
        p2.setValue(value);
        CustomProperty cp2 = new CustomProperty(p2, name);
        return this.put(cp2);
    }

    public Object get(String name) {
        Long id2 = this.dictionaryNameToID.get(name);
        CustomProperty cp2 = (CustomProperty)super.get(id2);
        return cp2 != null ? cp2.getValue() : null;
    }

    @Override
    public Object put(String name, Date value) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(-1L);
        p2.setType(64L);
        p2.setValue(value);
        CustomProperty cp2 = new CustomProperty(p2, name);
        return this.put(cp2);
    }

    @Override
    public Set keySet() {
        return this.dictionaryNameToID.keySet();
    }

    public Set<String> nameSet() {
        return this.dictionaryNameToID.keySet();
    }

    public Set<String> idSet() {
        return this.dictionaryNameToID.keySet();
    }

    public void setCodepage(int codepage) {
        MutableProperty p2 = new MutableProperty();
        p2.setID(1L);
        p2.setType(2L);
        p2.setValue(codepage);
        this.put(new CustomProperty(p2));
    }

    Map<Long, String> getDictionary() {
        return this.dictionaryIDToName;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return super.containsKey(key);
        }
        if (key instanceof String) {
            return super.containsKey(this.dictionaryNameToID.get(key));
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof CustomProperty) {
            return super.containsValue(value);
        }
        for (CustomProperty cp2 : super.values()) {
            if (cp2.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public int getCodepage() {
        int codepage = -1;
        Iterator i2 = this.values().iterator();
        while (codepage == -1 && i2.hasNext()) {
            CustomProperty cp2 = (CustomProperty)i2.next();
            if (cp2.getID() != 1L) continue;
            codepage = (Integer)cp2.getValue();
        }
        return codepage;
    }

    public boolean isPure() {
        return this.isPure;
    }

    public void setPure(boolean isPure) {
        this.isPure = isPure;
    }
}

