/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.POITextExtractor;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.extractor.EventBasedExcelExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class OLE2ExtractorFactory {
    private static final POILogger LOGGER = POILogFactory.getLogger(OLE2ExtractorFactory.class);
    private static final ThreadLocal<Boolean> threadPreferEventExtractors = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static Boolean allPreferEventExtractors;

    public static boolean getThreadPrefersEventExtractors() {
        return threadPreferEventExtractors.get();
    }

    public static Boolean getAllThreadsPreferEventExtractors() {
        return allPreferEventExtractors;
    }

    public static void setThreadPrefersEventExtractors(boolean preferEventExtractors) {
        threadPreferEventExtractors.set(preferEventExtractors);
    }

    public static void setAllThreadsPreferEventExtractors(Boolean preferEventExtractors) {
        allPreferEventExtractors = preferEventExtractors;
    }

    protected static boolean getPreferEventExtractor() {
        if (allPreferEventExtractors != null) {
            return allPreferEventExtractors;
        }
        return threadPreferEventExtractors.get();
    }

    public static POIOLE2TextExtractor createExtractor(POIFSFileSystem fs2) throws IOException {
        return (POIOLE2TextExtractor)OLE2ExtractorFactory.createExtractor(fs2.getRoot());
    }

    public static POIOLE2TextExtractor createExtractor(NPOIFSFileSystem fs2) throws IOException {
        return (POIOLE2TextExtractor)OLE2ExtractorFactory.createExtractor(fs2.getRoot());
    }

    public static POIOLE2TextExtractor createExtractor(OPOIFSFileSystem fs2) throws IOException {
        return (POIOLE2TextExtractor)OLE2ExtractorFactory.createExtractor(fs2.getRoot());
    }

    public static POITextExtractor createExtractor(InputStream input) throws IOException {
        Class<?> cls = OLE2ExtractorFactory.getOOXMLClass();
        if (cls != null) {
            try {
                Method m2 = cls.getDeclaredMethod("createExtractor", InputStream.class);
                return (POITextExtractor)m2.invoke(null, input);
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Error creating Extractor for InputStream", e2);
            }
        }
        return OLE2ExtractorFactory.createExtractor(new NPOIFSFileSystem(input));
    }

    private static Class<?> getOOXMLClass() {
        try {
            return OLE2ExtractorFactory.class.getClassLoader().loadClass("org.apache.poi.extractor.ExtractorFactory");
        }
        catch (ClassNotFoundException e2) {
            LOGGER.log(5, new Object[]{"POI OOXML jar missing"});
            return null;
        }
    }

    private static Class<?> getScratchpadClass() {
        try {
            return OLE2ExtractorFactory.class.getClassLoader().loadClass("org.apache.poi.extractor.OLE2ScratchpadExtractorFactory");
        }
        catch (ClassNotFoundException e2) {
            LOGGER.log(7, new Object[]{"POI Scratchpad jar missing"});
            throw new IllegalStateException("POI Scratchpad jar missing, required for ExtractorFactory");
        }
    }

    public static POITextExtractor createExtractor(DirectoryNode poifsDir) throws IOException {
        for (String workbookName : InternalWorkbook.WORKBOOK_DIR_ENTRY_NAMES) {
            if (!poifsDir.hasEntry(workbookName)) continue;
            if (OLE2ExtractorFactory.getPreferEventExtractor()) {
                return new EventBasedExcelExtractor(poifsDir);
            }
            return new ExcelExtractor(poifsDir);
        }
        if (poifsDir.hasEntry("Book")) {
            throw new OldExcelFormatException("Old Excel Spreadsheet format (1-95) found. Please call OldExcelExtractor directly for basic text extraction");
        }
        Class<?> cls = OLE2ExtractorFactory.getScratchpadClass();
        try {
            Method m2 = cls.getDeclaredMethod("createExtractor", DirectoryNode.class);
            POITextExtractor ext = (POITextExtractor)m2.invoke(null, poifsDir);
            if (ext != null) {
                return ext;
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Error creating Scratchpad Extractor", e2);
        }
        throw new IllegalArgumentException("No supported documents found in the OLE2 stream");
    }

    public static POITextExtractor[] getEmbededDocsTextExtractors(POIOLE2TextExtractor ext) throws IOException {
        ArrayList<Entry> dirs = new ArrayList<Entry>();
        ArrayList nonPOIFS = new ArrayList();
        DirectoryEntry root = ext.getRoot();
        if (root == null) {
            throw new IllegalStateException("The extractor didn't know which POIFS it came from!");
        }
        if (ext instanceof ExcelExtractor) {
            Iterator<Entry> it2 = root.getEntries();
            while (it2.hasNext()) {
                Entry entry = it2.next();
                if (!entry.getName().startsWith("MBD")) continue;
                dirs.add(entry);
            }
        } else {
            Class<?> cls = OLE2ExtractorFactory.getScratchpadClass();
            try {
                Method m2 = cls.getDeclaredMethod("identifyEmbeddedResources", POIOLE2TextExtractor.class, List.class, List.class);
                m2.invoke(null, ext, dirs, nonPOIFS);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Error checking for Scratchpad embedded resources", e2);
            }
        }
        if (dirs.size() == 0 && nonPOIFS.size() == 0) {
            return new POITextExtractor[0];
        }
        ArrayList<POITextExtractor> e3 = new ArrayList<POITextExtractor>();
        for (Entry dir : dirs) {
            e3.add(OLE2ExtractorFactory.createExtractor((DirectoryNode)dir));
        }
        for (InputStream nonPOIF : nonPOIFS) {
            try {
                e3.add(OLE2ExtractorFactory.createExtractor(nonPOIF));
            }
            catch (IllegalArgumentException ie2) {
                LOGGER.log(5, new Object[]{ie2});
            }
            catch (Exception xe) {
                LOGGER.log(5, new Object[]{xe});
            }
        }
        return e3.toArray(new POITextExtractor[e3.size()]);
    }
}

