/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.dev;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.openxml4j.opc.internal.ZipHelper;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class OOXMLPrettyPrint {
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder documentBuilder;

    public OOXMLPrettyPrint() throws ParserConfigurationException {
        ZipSecureFile.setMinInflateRatio(1.0E-5);
        this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
    }

    public static void main(String[] args) throws Exception {
        if (args.length <= 1 || args.length % 2 != 0) {
            System.err.println("Use:");
            System.err.println("\tjava OOXMLPrettyPrint [<filename> <outfilename>] ...");
            System.exit(1);
        }
        for (int i2 = 0; i2 < args.length; i2 += 2) {
            File f2 = new File(args[i2]);
            if (!f2.exists()) {
                System.err.println("Error, file not found!");
                System.err.println("\t" + f2.toString());
                System.exit(2);
            }
            OOXMLPrettyPrint.handleFile(f2, new File(args[i2 + 1]));
        }
        System.out.println("Done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleFile(File file, File outFile) throws ZipException, IOException, TransformerException, ParserConfigurationException {
        System.out.println("Reading zip-file " + file + " and writing pretty-printed XML to " + outFile);
        ZipFile zipFile = ZipHelper.openZipFile(file);
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            try {
                new OOXMLPrettyPrint().handle(zipFile, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            zipFile.close();
            System.out.println();
        }
    }

    private void handle(ZipFile file, ZipOutputStream out) throws IOException, TransformerException {
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            out.putNextEntry(new ZipEntry(name));
            try {
                if (name.endsWith(".xml") || name.endsWith(".rels")) {
                    Document document = this.documentBuilder.parse(new InputSource(file.getInputStream(entry)));
                    document.setXmlStandalone(true);
                    OOXMLPrettyPrint.pretty(document, out, 2);
                } else {
                    System.out.println("Not pretty-printing non-XML file " + name);
                    IOUtils.copy(file.getInputStream(entry), out);
                }
            }
            catch (Exception e2) {
                throw new IOException("While handling entry " + name, e2);
            }
            finally {
                out.closeEntry();
            }
            System.out.print(".");
        }
    }

    private static void pretty(Document document, OutputStream outputStream, int indent) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        if (indent > 0) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
        }
        StreamResult result = new StreamResult(outputStream);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
    }
}

