/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLFactory;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.xmlbeans.impl.common.SystemCache;

public abstract class POIXMLDocument
extends POIXMLDocumentPart
implements Closeable {
    public static final String DOCUMENT_CREATOR = "Apache POI";
    public static final String OLE_OBJECT_REL_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject";
    public static final String PACK_OBJECT_REL_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package";
    private OPCPackage pkg;
    private POIXMLProperties properties;

    protected POIXMLDocument(OPCPackage pkg) {
        super(pkg);
        this.init(pkg);
    }

    protected POIXMLDocument(OPCPackage pkg, String coreDocumentRel) {
        super(pkg, coreDocumentRel);
        this.init(pkg);
    }

    private void init(OPCPackage p2) {
        this.pkg = p2;
        SystemCache.get().setSaxLoader(null);
    }

    public static OPCPackage openPackage(String path) throws IOException {
        try {
            return OPCPackage.open(path);
        }
        catch (InvalidFormatException e2) {
            throw new IOException(e2.toString(), e2);
        }
    }

    public OPCPackage getPackage() {
        return this.pkg;
    }

    protected PackagePart getCorePart() {
        return this.getPackagePart();
    }

    protected PackagePart[] getRelatedByType(String contentType) throws InvalidFormatException {
        PackageRelationshipCollection partsC = this.getPackagePart().getRelationshipsByType(contentType);
        PackagePart[] parts = new PackagePart[partsC.size()];
        int count = 0;
        for (PackageRelationship rel : partsC) {
            parts[count] = this.getPackagePart().getRelatedPart(rel);
            ++count;
        }
        return parts;
    }

    @Deprecated
    public static boolean hasOOXMLHeader(InputStream inp) throws IOException {
        return DocumentFactoryHelper.hasOOXMLHeader(inp);
    }

    public POIXMLProperties getProperties() {
        if (this.properties == null) {
            try {
                this.properties = new POIXMLProperties(this.pkg);
            }
            catch (Exception e2) {
                throw new POIXMLException(e2);
            }
        }
        return this.properties;
    }

    public abstract List<PackagePart> getAllEmbedds() throws OpenXML4JException;

    protected final void load(POIXMLFactory factory) throws IOException {
        HashMap<PackagePart, POIXMLDocumentPart> context = new HashMap<PackagePart, POIXMLDocumentPart>();
        try {
            this.read(factory, context);
        }
        catch (OpenXML4JException e2) {
            throw new POIXMLException(e2);
        }
        this.onDocumentRead();
        context.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.pkg != null) {
            if (this.pkg.getPackageAccess() == PackageAccess.READ) {
                this.pkg.revert();
            } else {
                this.pkg.close();
            }
            this.pkg = null;
        }
    }

    public final void write(OutputStream stream) throws IOException {
        OPCPackage p2 = this.getPackage();
        if (p2 == null) {
            throw new IOException("Cannot write data, document seems to have been closed already");
        }
        HashSet<PackagePart> context = new HashSet<PackagePart>();
        this.onSave(context);
        context.clear();
        this.getProperties().commit();
        p2.save(stream);
    }
}

