/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class POIDocument
implements Closeable {
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    protected DirectoryNode directory;
    private static final POILogger logger = POILogFactory.getLogger(POIDocument.class);
    private boolean initialized = false;

    protected POIDocument(DirectoryNode dir) {
        this.directory = dir;
    }

    protected POIDocument(OPOIFSFileSystem fs2) {
        this(fs2.getRoot());
    }

    protected POIDocument(NPOIFSFileSystem fs2) {
        this(fs2.getRoot());
    }

    protected POIDocument(POIFSFileSystem fs2) {
        this(fs2.getRoot());
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    public void createInformationProperties() {
        if (!this.initialized) {
            this.readProperties();
        }
        if (this.sInf == null) {
            this.sInf = PropertySetFactory.newSummaryInformation();
        }
        if (this.dsInf == null) {
            this.dsInf = PropertySetFactory.newDocumentSummaryInformation();
        }
    }

    protected void readProperties() {
        PropertySet ps = this.getPropertySet("\u0005DocumentSummaryInformation");
        if (ps instanceof DocumentSummaryInformation) {
            this.dsInf = (DocumentSummaryInformation)ps;
        } else if (ps != null) {
            logger.log(5, "DocumentSummaryInformation property set came back with wrong class - ", ps.getClass());
        } else {
            logger.log(5, new Object[]{"DocumentSummaryInformation property set came back as null"});
        }
        ps = this.getPropertySet("\u0005SummaryInformation");
        if (ps instanceof SummaryInformation) {
            this.sInf = (SummaryInformation)ps;
        } else if (ps != null) {
            logger.log(5, "SummaryInformation property set came back with wrong class - ", ps.getClass());
        } else {
            logger.log(5, new Object[]{"SummaryInformation property set came back as null"});
        }
        this.initialized = true;
    }

    protected PropertySet getPropertySet(String setName) {
        return this.getPropertySet(setName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected PropertySet getPropertySet(String setName, EncryptionInfo encryptionInfo) {
        PropertySet propertySet;
        DocumentInputStream dis;
        String step;
        NPOIFSFileSystem encPoifs;
        block25: {
            DirectoryNode dirNode;
            block23: {
                InputStream is2;
                block24: {
                    dirNode = this.directory;
                    encPoifs = null;
                    step = "getting";
                    if (encryptionInfo != null) {
                        step = "getting encrypted";
                        is2 = encryptionInfo.getDecryptor().getDataStream(this.directory);
                        try {
                            encPoifs = new NPOIFSFileSystem(is2);
                            dirNode = encPoifs.getRoot();
                        }
                        finally {
                            is2.close();
                        }
                    }
                    if (dirNode != null && dirNode.hasEntry(setName)) break block23;
                    is2 = null;
                    if (encPoifs == null) break block24;
                    try {
                        encPoifs.close();
                    }
                    catch (IOException e2) {
                        logger.log(5, new Object[]{"Error closing encrypted property poifs", e2});
                    }
                }
                return is2;
            }
            step = "getting";
            dis = dirNode.createDocumentInputStream(dirNode.getEntry(setName));
            step = "creating";
            propertySet = PropertySetFactory.create(dis);
            dis.close();
            if (encPoifs == null) break block25;
            try {
                encPoifs.close();
            }
            catch (IOException e3) {
                logger.log(5, new Object[]{"Error closing encrypted property poifs", e3});
            }
        }
        return propertySet;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        dis.close();
                        throw throwable;
                    }
                    catch (Exception e4) {
                        logger.log(5, new Object[]{"Error " + step + " property set with name " + setName, e4});
                        PropertySet propertySet2 = null;
                        if (encPoifs != null) {
                            try {
                                encPoifs.close();
                            }
                            catch (IOException e5) {
                                logger.log(5, new Object[]{"Error closing encrypted property poifs", e5});
                            }
                        }
                        return propertySet2;
                    }
                }
                catch (Throwable throwable2) {
                    if (encPoifs != null) {
                        try {
                            encPoifs.close();
                        }
                        catch (IOException e6) {
                            logger.log(5, new Object[]{"Error closing encrypted property poifs", e6});
                        }
                    }
                    throw throwable2;
                }
            }
        }
    }

    protected void writeProperties() throws IOException {
        this.validateInPlaceWritePossible();
        this.writeProperties(this.directory.getFileSystem(), null);
    }

    protected void writeProperties(NPOIFSFileSystem outFS) throws IOException {
        this.writeProperties(outFS, null);
    }

    protected void writeProperties(NPOIFSFileSystem outFS, List<String> writtenEntries) throws IOException {
        DocumentSummaryInformation dsi;
        SummaryInformation si = this.getSummaryInformation();
        if (si != null) {
            this.writePropertySet("\u0005SummaryInformation", si, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005SummaryInformation");
            }
        }
        if ((dsi = this.getDocumentSummaryInformation()) != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", dsi, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005DocumentSummaryInformation");
            }
        }
    }

    protected void writePropertySet(String name, PropertySet set, NPOIFSFileSystem outFS) throws IOException {
        try {
            MutablePropertySet mSet = new MutablePropertySet(set);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mSet.write(bOut);
            byte[] data = bOut.toByteArray();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            outFS.createOrUpdateDocument(bIn, name);
            logger.log(3, new Object[]{"Wrote property set " + name + " of size " + data.length});
        }
        catch (WritingNotSupportedException wnse) {
            logger.log(7, new Object[]{"Couldn't write property set with name " + name + " as not supported by HPSF yet"});
        }
    }

    protected void validateInPlaceWritePossible() throws IllegalStateException {
        if (this.directory == null) {
            throw new IllegalStateException("Newly created Document, cannot save in-place");
        }
        if (this.directory.getParent() != null) {
            throw new IllegalStateException("This is not the root Document, cannot save embedded resource in-place");
        }
        if (this.directory.getFileSystem() == null || !this.directory.getFileSystem().isInPlaceWriteable()) {
            throw new IllegalStateException("Opened read-only or via an InputStream, a Writeable File is required");
        }
    }

    public abstract void write() throws IOException;

    public abstract void write(File var1) throws IOException;

    public abstract void write(OutputStream var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.directory != null && this.directory.getNFileSystem() != null) {
            this.directory.getNFileSystem().close();
            this.directory = null;
        }
    }

    @Internal
    public DirectoryNode getDirectory() {
        return this.directory;
    }
}

