/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UriPatternMatcher {
    private final Map map = new HashMap();

    public void register(String pattern, Object obj) {
        if (pattern == null) {
            throw new IllegalArgumentException("URI request pattern may not be null");
        }
        this.map.put(pattern, obj);
    }

    public void unregister(String pattern) {
        if (pattern == null) {
            return;
        }
        this.map.remove(pattern);
    }

    public void setHandlers(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map of handlers may not be null");
        }
        this.map.clear();
        this.map.putAll(map);
    }

    public Object lookup(String requestURI) {
        Object handler;
        if (requestURI == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        int index = requestURI.indexOf("?");
        if (index != -1) {
            requestURI = requestURI.substring(0, index);
        }
        if ((handler = this.map.get(requestURI)) == null) {
            String bestMatch = null;
            Iterator it2 = this.map.keySet().iterator();
            while (it2.hasNext()) {
                String pattern = (String)it2.next();
                if (!this.matchUriRequestPattern(pattern, requestURI) || bestMatch != null && bestMatch.length() >= pattern.length() && (bestMatch.length() != pattern.length() || !pattern.endsWith("*"))) continue;
                handler = this.map.get(pattern);
                bestMatch = pattern;
            }
        }
        return handler;
    }

    protected boolean matchUriRequestPattern(String pattern, String requestUri) {
        if (pattern.equals("*")) {
            return true;
        }
        return pattern.endsWith("*") && requestUri.startsWith(pattern.substring(0, pattern.length() - 1)) || pattern.startsWith("*") && requestUri.endsWith(pattern.substring(1, pattern.length()));
    }
}

