/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

public abstract class AbstractSessionOutputBuffer
implements SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final int MAX_CHUNK = 256;
    private OutputStream outstream;
    private ByteArrayBuffer buffer;
    private String charset = "US-ASCII";
    private boolean ascii = true;
    private HttpTransportMetricsImpl metrics;

    protected void init(OutputStream outstream, int buffersize, HttpParams params) {
        if (outstream == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (buffersize <= 0) {
            throw new IllegalArgumentException("Buffer size may not be negative or zero");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.outstream = outstream;
        this.buffer = new ByteArrayBuffer(buffersize);
        this.charset = HttpProtocolParams.getHttpElementCharset(params);
        this.ascii = this.charset.equalsIgnoreCase("US-ASCII") || this.charset.equalsIgnoreCase("ASCII");
        this.metrics = new HttpTransportMetricsImpl();
    }

    protected void flushBuffer() throws IOException {
        int len = this.buffer.length();
        if (len > 0) {
            this.outstream.write(this.buffer.buffer(), 0, len);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(len);
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.outstream.flush();
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            return;
        }
        if (len > 256 || len > this.buffer.capacity()) {
            this.flushBuffer();
            this.outstream.write(b2, off, len);
            this.metrics.incrementBytesTransferred(len);
        } else {
            int freecapacity = this.buffer.capacity() - this.buffer.length();
            if (len > freecapacity) {
                this.flushBuffer();
            }
            this.buffer.append(b2, off, len);
        }
    }

    public void write(byte[] b2) throws IOException {
        if (b2 == null) {
            return;
        }
        this.write(b2, 0, b2.length);
    }

    public void write(int b2) throws IOException {
        if (this.buffer.isFull()) {
            this.flushBuffer();
        }
        this.buffer.append(b2);
    }

    public void writeLine(String s2) throws IOException {
        if (s2 == null) {
            return;
        }
        if (s2.length() > 0) {
            this.write(s2.getBytes(this.charset));
        }
        this.write(CRLF);
    }

    public void writeLine(CharArrayBuffer s2) throws IOException {
        if (s2 == null) {
            return;
        }
        if (this.ascii) {
            int chunk;
            int off = 0;
            for (int remaining = s2.length(); remaining > 0; remaining -= chunk) {
                chunk = this.buffer.capacity() - this.buffer.length();
                if ((chunk = Math.min(chunk, remaining)) > 0) {
                    this.buffer.append(s2, off, chunk);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                off += chunk;
            }
        } else {
            byte[] tmp = s2.toString().getBytes(this.charset);
            this.write(tmp);
        }
        this.write(CRLF);
    }

    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

