/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.Immutable;
import org.apache.commons.logging.Log;

@Immutable
public class Wire {
    private final Log log;

    public Wire(Log log) {
        this.log = log;
    }

    private void wire(String header, InputStream instream) throws IOException {
        int ch2;
        StringBuilder buffer = new StringBuilder();
        while ((ch2 = instream.read()) != -1) {
            if (ch2 == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch2 == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                this.log.debug(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch2 < 32 || ch2 > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch2));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch2);
        }
        if (buffer.length() > 0) {
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, header);
            this.log.debug(buffer.toString());
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", outstream);
    }

    public void input(InputStream instream) throws IOException {
        if (instream == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", instream);
    }

    public void output(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", new ByteArrayInputStream(b2, off, len));
    }

    public void input(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", new ByteArrayInputStream(b2, off, len));
    }

    public void output(byte[] b2) throws IOException {
        if (b2 == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.wire(">> ", new ByteArrayInputStream(b2));
    }

    public void input(byte[] b2) throws IOException {
        if (b2 == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.wire("<< ", new ByteArrayInputStream(b2));
    }

    public void output(int b2) throws IOException {
        this.output(new byte[]{(byte)b2});
    }

    public void input(int b2) throws IOException {
        this.input(new byte[]{(byte)b2});
    }

    public void output(String s2) throws IOException {
        if (s2 == null) {
            throw new IllegalArgumentException("Output may not be null");
        }
        this.output(s2.getBytes());
    }

    public void input(String s2) throws IOException {
        if (s2 == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        this.input(s2.getBytes());
    }
}

