/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import net.jcip.annotations.Immutable;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class LoggingSessionInputBuffer
implements SessionInputBuffer {
    private final SessionInputBuffer in;
    private final Wire wire;

    public LoggingSessionInputBuffer(SessionInputBuffer in2, Wire wire) {
        this.in = in2;
        this.wire = wire;
    }

    public boolean isDataAvailable(int timeout) throws IOException {
        return this.in.isDataAvailable(timeout);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int l2 = this.in.read(b2, off, len);
        if (this.wire.enabled() && l2 > 0) {
            this.wire.input(b2, off, l2);
        }
        return l2;
    }

    public int read() throws IOException {
        int l2 = this.in.read();
        if (this.wire.enabled() && l2 != -1) {
            this.wire.input(l2);
        }
        return l2;
    }

    public int read(byte[] b2) throws IOException {
        int l2 = this.in.read(b2);
        if (this.wire.enabled() && l2 > 0) {
            this.wire.input(b2, 0, l2);
        }
        return l2;
    }

    public String readLine() throws IOException {
        String s2 = this.in.readLine();
        if (this.wire.enabled() && s2 != null) {
            this.wire.input(s2 + "[EOL]");
        }
        return s2;
    }

    public int readLine(CharArrayBuffer buffer) throws IOException {
        int l2 = this.in.readLine(buffer);
        if (this.wire.enabled() && l2 >= 0) {
            int pos = buffer.length() - l2;
            String s2 = new String(buffer.buffer(), pos, l2);
            this.wire.input(s2 + "[EOL]");
        }
        return l2;
    }

    public HttpTransportMetrics getMetrics() {
        return this.in.getMetrics();
    }
}

