/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.ParameterStyle;
import net.oauth.client.ExcerptInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessage {
    public String method;
    public URL url;
    public final List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
    protected InputStream body = null;
    public static final String REQUEST = "HTTP request";
    public static final String RESPONSE = "HTTP response";
    public static final String STATUS_CODE = "HTTP status";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final Pattern CHARSET = Pattern.compile("; *charset *= *([^;\"]*|\"([^\"]|\\\\\")*\")(;|$)");

    public HttpMessage() {
        this(null, null);
    }

    public HttpMessage(String method, URL url) {
        this(method, url, null);
    }

    public HttpMessage(String method, URL url, InputStream body) {
        this.method = method;
        this.url = url;
        this.body = body;
    }

    public final String getHeader(String name) {
        String value = null;
        for (Map.Entry<String, String> header : this.headers) {
            if (!HttpMessage.equalsIgnoreCase(name, header.getKey())) continue;
            value = header.getValue();
        }
        return value;
    }

    public String removeHeaders(String name) {
        String value = null;
        Iterator<Map.Entry<String, String>> i2 = this.headers.iterator();
        while (i2.hasNext()) {
            Map.Entry<String, String> header = i2.next();
            if (!HttpMessage.equalsIgnoreCase(name, header.getKey())) continue;
            value = header.getValue();
            i2.remove();
        }
        return value;
    }

    public final String getContentCharset() {
        return HttpMessage.getCharset(this.getHeader(CONTENT_TYPE));
    }

    public final InputStream getBody() throws IOException {
        InputStream raw;
        if (this.body == null && (raw = this.openBody()) != null) {
            this.body = new ExcerptInputStream(raw);
        }
        return this.body;
    }

    protected InputStream openBody() throws IOException {
        return null;
    }

    public void dump(Map<String, Object> into) throws IOException {
    }

    public static HttpMessage newRequest(OAuthMessage from, ParameterStyle style) throws IOException {
        boolean isPost = "POST".equalsIgnoreCase(from.method);
        InputStream body = from.getBodyAsStream();
        if (!(style != ParameterStyle.BODY || isPost && body == null)) {
            style = ParameterStyle.QUERY_STRING;
        }
        String url = from.URL;
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>(from.getHeaders());
        switch (style) {
            case QUERY_STRING: {
                url = OAuth.addParameters(url, from.getParameters());
                break;
            }
            case BODY: {
                byte[] form = OAuth.formEncode(from.getParameters()).getBytes(from.getBodyEncoding());
                headers.add(new OAuth.Parameter(CONTENT_TYPE, "application/x-www-form-urlencoded"));
                headers.add(new OAuth.Parameter(CONTENT_LENGTH, form.length + ""));
                body = new ByteArrayInputStream(form);
                break;
            }
            case AUTHORIZATION_HEADER: {
                headers.add(new OAuth.Parameter("Authorization", from.getAuthorizationHeader(null)));
                List<Map.Entry<String, String>> others = from.getParameters();
                if (others == null || others.isEmpty()) break;
                others = new ArrayList<Map.Entry<String, String>>(others);
                Iterator<Map.Entry<String, String>> p2 = others.iterator();
                while (p2.hasNext()) {
                    if (!p2.next().getKey().startsWith("oauth_")) continue;
                    p2.remove();
                }
                if (isPost && body == null) {
                    byte[] form = OAuth.formEncode(others).getBytes(from.getBodyEncoding());
                    headers.add(new OAuth.Parameter(CONTENT_TYPE, "application/x-www-form-urlencoded"));
                    headers.add(new OAuth.Parameter(CONTENT_LENGTH, form.length + ""));
                    body = new ByteArrayInputStream(form);
                    break;
                }
                url = OAuth.addParameters(url, others);
            }
        }
        HttpMessage httpRequest = new HttpMessage(from.method, new URL(url), body);
        httpRequest.headers.addAll(headers);
        return httpRequest;
    }

    private static boolean equalsIgnoreCase(String x2, String y2) {
        if (x2 == null) {
            return y2 == null;
        }
        return x2.equalsIgnoreCase(y2);
    }

    private static final String getCharset(String mimeType) {
        Matcher m2;
        if (mimeType != null && (m2 = CHARSET.matcher(mimeType)).find()) {
            String charset = m2.group(1);
            if (charset.length() >= 2 && charset.charAt(0) == '\"' && charset.charAt(charset.length() - 1) == '\"') {
                charset = charset.substring(1, charset.length() - 1);
                charset = charset.replace("\\\"", "\"");
            }
            return charset;
        }
        return DEFAULT_CHARSET;
    }
}

