/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.client.ExcerptInputStream;
import net.oauth.http.HttpResponseMessage;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodResponse
extends HttpResponseMessage {
    private final HttpRequestBase httpRequest;
    private final HttpResponse httpResponse;
    private final byte[] requestBody;
    private final String requestEncoding;

    public HttpMethodResponse(HttpRequestBase request, HttpResponse response, byte[] requestBody, String requestEncoding) throws IOException {
        super(request.getMethod(), new URL(request.getURI().toString()));
        this.httpRequest = request;
        this.httpResponse = response;
        this.requestBody = requestBody;
        this.requestEncoding = requestEncoding;
        this.headers.addAll(this.getHeaders());
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    public InputStream openBody() throws IOException {
        return this.httpResponse.getEntity().getContent();
    }

    private List<Map.Entry<String, String>> getHeaders() {
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        Header[] allHeaders = this.httpResponse.getAllHeaders();
        if (allHeaders != null) {
            for (Header header : allHeaders) {
                headers.add(new OAuth.Parameter(header.getName(), header.getValue()));
            }
        }
        return headers;
    }

    @Override
    public void dump(Map<String, Object> into) throws IOException {
        HttpEntityEnclosingRequest r2;
        long contentLength;
        super.dump(into);
        StringBuilder request = new StringBuilder(this.httpRequest.getMethod());
        request.append(" ").append(this.httpRequest.getURI().getPath());
        String query = this.httpRequest.getURI().getQuery();
        if (query != null && query.length() > 0) {
            request.append("?").append(query);
        }
        request.append("\r\n");
        for (Header header : this.httpRequest.getAllHeaders()) {
            request.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
        }
        if (this.httpRequest instanceof HttpEntityEnclosingRequest && (contentLength = (r2 = (HttpEntityEnclosingRequest)((Object)this.httpRequest)).getEntity().getContentLength()) >= 0L) {
            request.append("Content-Length: ").append(contentLength).append("\r\n");
        }
        request.append("\r\n");
        if (this.requestBody != null) {
            request.append(new String(this.requestBody, this.requestEncoding));
        }
        into.put("HTTP request", request.toString());
        StringBuilder response = new StringBuilder();
        String value = this.httpResponse.getStatusLine().toString();
        response.append(value).append("\r\n");
        for (Header header : this.httpResponse.getAllHeaders()) {
            String name = header.getName();
            value = header.getValue();
            response.append(name).append(": ").append(value).append("\r\n");
        }
        response.append("\r\n");
        if (this.body != null) {
            response.append(new String(((ExcerptInputStream)this.body).getExcerpt(), this.getContentCharset()));
        }
        into.put("HTTP response", response.toString());
    }
}

