/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.client.ExcerptInputStream;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLConnectionResponse
extends HttpResponseMessage {
    private final String requestHeaders;
    private final byte[] requestExcerpt;
    private final String requestEncoding;
    private final URLConnection connection;

    public URLConnectionResponse(HttpMessage request, String requestHeaders, byte[] requestExcerpt, URLConnection connection) throws IOException {
        super(request.method, request.url);
        this.requestHeaders = requestHeaders;
        this.requestExcerpt = requestExcerpt;
        this.requestEncoding = request.getContentCharset();
        this.connection = connection;
        this.headers.addAll(this.getHeaders());
    }

    @Override
    public int getStatusCode() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseCode();
        }
        return 200;
    }

    @Override
    public InputStream openBody() {
        try {
            return this.connection.getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private List<Map.Entry<String, String>> getHeaders() {
        String value;
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        boolean foundContentType = false;
        int i2 = 0;
        while ((value = this.connection.getHeaderField(i2)) != null) {
            String name = this.connection.getHeaderFieldKey(i2);
            if (name != null) {
                headers.add(new OAuth.Parameter(name, value));
                if ("Content-Type".equalsIgnoreCase(name)) {
                    foundContentType = true;
                }
            }
            ++i2;
        }
        if (!foundContentType) {
            headers.add(new OAuth.Parameter("Content-Type", this.connection.getContentType()));
        }
        return headers;
    }

    @Override
    public void dump(Map<String, Object> into) throws IOException {
        String value;
        super.dump(into);
        StringBuilder request = new StringBuilder(this.requestHeaders);
        request.append("\r\n");
        if (this.requestExcerpt != null) {
            request.append(new String(this.requestExcerpt, this.requestEncoding));
        }
        into.put("HTTP request", request.toString());
        HttpURLConnection http = this.connection instanceof HttpURLConnection ? (HttpURLConnection)this.connection : null;
        StringBuilder response = new StringBuilder();
        int i2 = 0;
        while ((value = this.connection.getHeaderField(i2)) != null) {
            String name = this.connection.getHeaderFieldKey(i2);
            if (i2 == 0 && name != null && http != null) {
                String firstLine = "HTTP " + this.getStatusCode();
                String message = http.getResponseMessage();
                if (message != null) {
                    firstLine = firstLine + " " + message;
                }
                response.append(firstLine).append("\r\n");
            }
            if (name != null) {
                response.append(name).append(": ");
                name = name.toLowerCase();
            }
            response.append(value).append("\r\n");
            ++i2;
        }
        response.append("\r\n");
        if (this.body != null) {
            response.append(new String(((ExcerptInputStream)this.body).getExcerpt(), this.getContentCharset()));
        }
        into.put("HTTP response", response.toString());
    }
}

