/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.reader;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONAwareEx;
import net.minidev.json.JSONStreamAware;
import net.minidev.json.JSONStreamAwareEx;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONUtil;
import net.minidev.json.JSONValue;
import net.minidev.json.reader.JsonWriterI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonWriter {
    private HashMap<Class<?>, JsonWriterI<?>> data = new HashMap();
    private LinkedList<WriterByInterface> writerInterfaces = new LinkedList();
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            value.writeJSONString(out);
        }
    };
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareExWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            value.writeJSONString(out, compression);
        }
    };
    public static final JsonWriterI<JSONAwareEx> JSONJSONAwareExWriter = new JsonWriterI<JSONAwareEx>(){

        @Override
        public <E extends JSONAwareEx> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            out.append(value.toJSONString(compression));
        }
    };
    public static final JsonWriterI<JSONAware> JSONJSONAwareWriter = new JsonWriterI<JSONAware>(){

        @Override
        public <E extends JSONAware> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            out.append(value.toJSONString());
        }
    };
    public static final JsonWriterI<Iterable<? extends Object>> JSONIterableWriter = new JsonWriterI<Iterable<? extends Object>>(){

        @Override
        public <E extends Iterable<? extends Object>> void writeJSONString(E list, Appendable out, JSONStyle compression) throws IOException {
            boolean first = true;
            compression.arrayStart(out);
            for (Object value : list) {
                if (first) {
                    first = false;
                    compression.arrayfirstObject(out);
                } else {
                    compression.arrayNextElm(out);
                }
                if (value == null) {
                    out.append("null");
                } else {
                    JSONValue.writeJSONString(value, out, compression);
                }
                compression.arrayObjectEnd(out);
            }
            compression.arrayStop(out);
        }
    };
    public static final JsonWriterI<Enum<?>> EnumWriter = new JsonWriterI<Enum<?>>(){

        @Override
        public <E extends Enum<?>> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            String s2 = value.name();
            compression.writeString(out, s2);
        }
    };
    public static final JsonWriterI<Map<String, ? extends Object>> JSONMapWriter = new JsonWriterI<Map<String, ? extends Object>>(){

        @Override
        public <E extends Map<String, ? extends Object>> void writeJSONString(E map, Appendable out, JSONStyle compression) throws IOException {
            boolean first = true;
            compression.objectStart(out);
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                Object v2 = entry.getValue();
                if (v2 == null && compression.ignoreNull()) continue;
                if (first) {
                    compression.objectFirstStart(out);
                    first = false;
                } else {
                    compression.objectNext(out);
                }
                JsonWriter.writeJSONKV(entry.getKey().toString(), v2, out, compression);
            }
            compression.objectStop(out);
        }
    };
    public static final JsonWriterI<Object> beansWriter = new JsonWriterI<Object>(){

        @Override
        public <E> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            try {
                boolean needSep = false;
                compression.objectStart(out);
                for (Class<?> nextClass = value.getClass(); nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = nextClass.getDeclaredFields()) {
                        int m2 = field.getModifiers();
                        if ((m2 & 0x98) > 0) continue;
                        Object v2 = null;
                        if ((m2 & 1) > 0) {
                            v2 = field.get(value);
                        } else {
                            Class<?> c2;
                            String g2 = JSONUtil.getGetterName(field.getName());
                            Method mtd = null;
                            try {
                                mtd = nextClass.getDeclaredMethod(g2, new Class[0]);
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            if (mtd == null && ((c2 = field.getType()) == Boolean.TYPE || c2 == Boolean.class)) {
                                g2 = JSONUtil.getIsName(field.getName());
                                mtd = nextClass.getDeclaredMethod(g2, new Class[0]);
                            }
                            if (mtd == null) continue;
                            v2 = mtd.invoke(value, new Object[0]);
                        }
                        if (v2 == null && compression.ignoreNull()) continue;
                        if (needSep) {
                            compression.objectNext(out);
                        } else {
                            needSep = true;
                        }
                        JsonWriter.writeJSONKV(field.getName(), v2, out, compression);
                    }
                }
                compression.objectStop(out);
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        }
    };
    public static final JsonWriterI<Object> arrayWriter = new JsonWriterI<Object>(){

        @Override
        public <E> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            compression.arrayStart(out);
            boolean needSep = false;
            for (Object o2 : (Object[])value) {
                if (needSep) {
                    compression.objectNext(out);
                } else {
                    needSep = true;
                }
                JSONValue.writeJSONString(o2, out, compression);
            }
            compression.arrayStop(out);
        }
    };

    public JsonWriter() {
        this.init();
    }

    public JsonWriterI getWriterByInterface(Class<?> clazz) {
        for (WriterByInterface w2 : this.writerInterfaces) {
            if (!w2._interface.isAssignableFrom(clazz)) continue;
            return w2._writer;
        }
        return null;
    }

    public JsonWriterI getWrite(Class cls) {
        return this.data.get(cls);
    }

    public void init() {
        this.registerWriter(new JsonWriterI<String>(){

            @Override
            public void writeJSONString(String value, Appendable out, JSONStyle compression) throws IOException {
                compression.writeString(out, value);
            }
        }, String.class);
        this.registerWriter(new JsonWriterI<Boolean>(){

            @Override
            public void writeJSONString(Boolean value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, Boolean.class);
        this.registerWriter(new JsonWriterI<Double>(){

            @Override
            public void writeJSONString(Double value, Appendable out, JSONStyle compression) throws IOException {
                if (value.isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            }
        }, Double.class);
        this.registerWriter(new JsonWriterI<Date>(){

            @Override
            public void writeJSONString(Date value, Appendable out, JSONStyle compression) throws IOException {
                out.append('\"');
                JSONValue.escape(value.toString(), out, compression);
                out.append('\"');
            }
        }, Date.class);
        this.registerWriter(new JsonWriterI<Float>(){

            @Override
            public void writeJSONString(Float value, Appendable out, JSONStyle compression) throws IOException {
                if (value.isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            }
        }, Float.class);
        this.registerWriter(new JsonWriterI<Number>(){

            @Override
            public void writeJSONString(Number value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, Integer.class, Long.class, Byte.class, Short.class, BigInteger.class);
        this.registerWriter(new JsonWriterI<Boolean>(){

            @Override
            public void writeJSONString(Boolean value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, Boolean.class);
        this.registerWriter(new JsonWriterI<Boolean>(){

            @Override
            public void writeJSONString(Boolean value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, Boolean.class);
        this.registerWriter(new JsonWriterI<int[]>(){

            @Override
            public void writeJSONString(int[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (int b2 : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Integer.toString(b2));
                }
                compression.arrayStop(out);
            }
        }, int[].class);
        this.registerWriter(new JsonWriterI<short[]>(){

            @Override
            public void writeJSONString(short[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (short b2 : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Short.toString(b2));
                }
                compression.arrayStop(out);
            }
        }, short[].class);
        this.registerWriter(new JsonWriterI<long[]>(){

            @Override
            public void writeJSONString(long[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (long b2 : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Long.toString(b2));
                }
                compression.arrayStop(out);
            }
        }, long[].class);
        this.registerWriter(new JsonWriterI<float[]>(){

            @Override
            public void writeJSONString(float[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (float b2 : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Float.toString(b2));
                }
                compression.arrayStop(out);
            }
        }, float[].class);
        this.registerWriter(new JsonWriterI<double[]>(){

            @Override
            public void writeJSONString(double[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (double b2 : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Double.toString(b2));
                }
                compression.arrayStop(out);
            }
        }, double[].class);
        this.registerWriter(new JsonWriterI<boolean[]>(){

            @Override
            public void writeJSONString(boolean[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (boolean b2 : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Boolean.toString(b2));
                }
                compression.arrayStop(out);
            }
        }, boolean[].class);
        this.addInterfaceWriterLast(JSONStreamAwareEx.class, JSONStreamAwareExWriter);
        this.addInterfaceWriterLast(JSONStreamAware.class, JSONStreamAwareWriter);
        this.addInterfaceWriterLast(JSONAwareEx.class, JSONJSONAwareExWriter);
        this.addInterfaceWriterLast(JSONAware.class, JSONJSONAwareWriter);
        this.addInterfaceWriterLast(Map.class, JSONMapWriter);
        this.addInterfaceWriterLast(Iterable.class, JSONIterableWriter);
        this.addInterfaceWriterLast(Enum.class, EnumWriter);
    }

    public void addInterfaceWriterFirst(Class<?> cls, JsonWriterI<?> writer) {
        this.writerInterfaces.addFirst(new WriterByInterface(cls, writer));
    }

    public void addInterfaceWriterLast(Class<?> cls, JsonWriterI<?> writer) {
        this.writerInterfaces.addLast(new WriterByInterface(cls, writer));
    }

    public <T> void registerWriter(JsonWriterI<T> writer, Class<?> ... cls) {
        for (Class<?> c2 : cls) {
            this.data.put(c2, writer);
        }
    }

    public static void writeJSONKV(String key, Object value, Appendable out, JSONStyle compression) throws IOException {
        if (key == null) {
            out.append("null");
        } else if (!compression.mustProtectKey(key)) {
            out.append(key);
        } else {
            out.append('\"');
            JSONValue.escape(key, out, compression);
            out.append('\"');
        }
        compression.objectEndOfKey(out);
        if (value instanceof String) {
            compression.writeString(out, (String)value);
        } else {
            JSONValue.writeJSONString(value, out, compression);
        }
        compression.objectElmStop(out);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WriterByInterface {
        public Class<?> _interface;
        public JsonWriterI<?> _writer;

        public WriterByInterface(Class<?> _interface, JsonWriterI<?> _writer) {
            this._interface = _interface;
            this._writer = _writer;
        }
    }
}

