/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;

class JStylerObj {
    public static final MPSimple MP_SIMPLE = new MPSimple();
    public static final MPTrue MP_TRUE = new MPTrue();
    public static final MPAgressive MP_AGGRESIVE = new MPAgressive();
    public static final EscapeLT ESCAPE_LT = new EscapeLT();
    public static final Escape4Web ESCAPE4Web = new Escape4Web();

    JStylerObj() {
    }

    public static boolean isSpace(char c2) {
        return c2 == '\r' || c2 == '\n' || c2 == '\t' || c2 == ' ';
    }

    public static boolean isSpecialChar(char c2) {
        return c2 == '\b' || c2 == '\f' || c2 == '\n';
    }

    public static boolean isSpecialOpen(char c2) {
        return c2 == '{' || c2 == '[' || c2 == ',' || c2 == ':';
    }

    public static boolean isSpecialClose(char c2) {
        return c2 == '}' || c2 == ']' || c2 == ',' || c2 == ':';
    }

    public static boolean isSpecial(char c2) {
        return c2 == '{' || c2 == '[' || c2 == ',' || c2 == '}' || c2 == ']' || c2 == ':' || c2 == '\'' || c2 == '\"';
    }

    public static boolean isUnicode(char c2) {
        return c2 >= '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff';
    }

    public static boolean isKeyword(String s2) {
        if (s2.length() < 3) {
            return false;
        }
        char c2 = s2.charAt(0);
        if (c2 == 'n') {
            return s2.equals("null");
        }
        if (c2 == 't') {
            return s2.equals("true");
        }
        if (c2 == 'f') {
            return s2.equals("false");
        }
        if (c2 == 'N') {
            return s2.equals("NaN");
        }
        return false;
    }

    private static class Escape4Web
    implements StringProtector {
        private Escape4Web() {
        }

        public void escape(String s2, Appendable sb) {
            try {
                int len = s2.length();
                block12: for (int i2 = 0; i2 < len; ++i2) {
                    char ch2 = s2.charAt(i2);
                    switch (ch2) {
                        case '\"': {
                            sb.append("\\\"");
                            continue block12;
                        }
                        case '\\': {
                            sb.append("\\\\");
                            continue block12;
                        }
                        case '\b': {
                            sb.append("\\b");
                            continue block12;
                        }
                        case '\f': {
                            sb.append("\\f");
                            continue block12;
                        }
                        case '\n': {
                            sb.append("\\n");
                            continue block12;
                        }
                        case '\r': {
                            sb.append("\\r");
                            continue block12;
                        }
                        case '\t': {
                            sb.append("\\t");
                            continue block12;
                        }
                        case '/': {
                            sb.append("\\/");
                            continue block12;
                        }
                        default: {
                            if (ch2 >= '\u0000' && ch2 <= '\u001f' || ch2 >= '\u007f' && ch2 <= '\u009f' || ch2 >= '\u2000' && ch2 <= '\u20ff') {
                                sb.append("\\u");
                                String hex = "0123456789ABCDEF";
                                sb.append(hex.charAt(ch2 >> 12 & 0xF));
                                sb.append(hex.charAt(ch2 >> 8 & 0xF));
                                sb.append(hex.charAt(ch2 >> 4 & 0xF));
                                sb.append(hex.charAt(ch2 >> 0 & 0xF));
                                continue block12;
                            }
                            sb.append(ch2);
                        }
                    }
                }
            }
            catch (IOException e2) {
                throw new RuntimeException("Impossible Error");
            }
        }
    }

    private static class EscapeLT
    implements StringProtector {
        private EscapeLT() {
        }

        public void escape(String s2, Appendable out) {
            try {
                int len = s2.length();
                block11: for (int i2 = 0; i2 < len; ++i2) {
                    char ch2 = s2.charAt(i2);
                    switch (ch2) {
                        case '\"': {
                            out.append("\\\"");
                            continue block11;
                        }
                        case '\\': {
                            out.append("\\\\");
                            continue block11;
                        }
                        case '\b': {
                            out.append("\\b");
                            continue block11;
                        }
                        case '\f': {
                            out.append("\\f");
                            continue block11;
                        }
                        case '\n': {
                            out.append("\\n");
                            continue block11;
                        }
                        case '\r': {
                            out.append("\\r");
                            continue block11;
                        }
                        case '\t': {
                            out.append("\\t");
                            continue block11;
                        }
                        default: {
                            if (ch2 >= '\u0000' && ch2 <= '\u001f' || ch2 >= '\u007f' && ch2 <= '\u009f' || ch2 >= '\u2000' && ch2 <= '\u20ff') {
                                out.append("\\u");
                                String hex = "0123456789ABCDEF";
                                out.append(hex.charAt(ch2 >> 12 & 0xF));
                                out.append(hex.charAt(ch2 >> 8 & 0xF));
                                out.append(hex.charAt(ch2 >> 4 & 0xF));
                                out.append(hex.charAt(ch2 >> 0 & 0xF));
                                continue block11;
                            }
                            out.append(ch2);
                        }
                    }
                }
            }
            catch (IOException e2) {
                throw new RuntimeException("Impossible Exeption");
            }
        }
    }

    public static interface StringProtector {
        public void escape(String var1, Appendable var2);
    }

    private static class MPAgressive
    implements MustProtect {
        private MPAgressive() {
        }

        public boolean mustBeProtect(String s2) {
            if (s2 == null) {
                return false;
            }
            int len = s2.length();
            if (len == 0) {
                return true;
            }
            if (s2.trim() != s2) {
                return true;
            }
            char ch2 = s2.charAt(0);
            if (JStylerObj.isSpecial(ch2) || JStylerObj.isUnicode(ch2)) {
                return true;
            }
            for (int i2 = 1; i2 < len; ++i2) {
                ch2 = s2.charAt(i2);
                if (!JStylerObj.isSpecialClose(ch2) && !JStylerObj.isUnicode(ch2)) continue;
                return true;
            }
            if (JStylerObj.isKeyword(s2)) {
                return true;
            }
            ch2 = s2.charAt(0);
            if (ch2 >= '0' && ch2 <= '9' || ch2 == '-') {
                int p2;
                for (p2 = 1; p2 < len && (ch2 = s2.charAt(p2)) >= '0' && ch2 <= '9'; ++p2) {
                }
                if (p2 == len) {
                    return true;
                }
                if (ch2 == '.') {
                    ++p2;
                }
                while (p2 < len && (ch2 = s2.charAt(p2)) >= '0' && ch2 <= '9') {
                    ++p2;
                }
                if (p2 == len) {
                    return true;
                }
                if (ch2 == 'E' || ch2 == 'e') {
                    if (++p2 == len) {
                        return false;
                    }
                    ch2 = s2.charAt(p2);
                    if (ch2 == '+' || ch2 == '-') {
                        ch2 = s2.charAt(++p2);
                    }
                }
                if (p2 == len) {
                    return false;
                }
                while (p2 < len && (ch2 = s2.charAt(p2)) >= '0' && ch2 <= '9') {
                    ++p2;
                }
                return p2 == len;
            }
            return false;
        }
    }

    private static class MPSimple
    implements MustProtect {
        private MPSimple() {
        }

        public boolean mustBeProtect(String s2) {
            if (s2 == null) {
                return false;
            }
            int len = s2.length();
            if (len == 0) {
                return true;
            }
            if (s2.trim() != s2) {
                return true;
            }
            char ch2 = s2.charAt(0);
            if (ch2 >= '0' && ch2 <= '9' || ch2 == '-') {
                return true;
            }
            for (int i2 = 0; i2 < len; ++i2) {
                ch2 = s2.charAt(i2);
                if (JStylerObj.isSpace(ch2)) {
                    return true;
                }
                if (JStylerObj.isSpecial(ch2)) {
                    return true;
                }
                if (JStylerObj.isSpecialChar(ch2)) {
                    return true;
                }
                if (!JStylerObj.isUnicode(ch2)) continue;
                return true;
            }
            return JStylerObj.isKeyword(s2);
        }
    }

    private static class MPTrue
    implements MustProtect {
        private MPTrue() {
        }

        public boolean mustBeProtect(String s2) {
            return true;
        }
    }

    public static interface MustProtect {
        public boolean mustBeProtect(String var1);
    }
}

