/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class JSONObjectUtils {
    public static JSONObject parse(String s2) throws java.text.ParseException {
        Object o2;
        try {
            o2 = new JSONParser(640).parse(s2);
        }
        catch (ParseException e2) {
            throw new java.text.ParseException("Invalid JSON: " + e2.getMessage(), 0);
        }
        if (o2 instanceof JSONObject) {
            return (JSONObject)o2;
        }
        throw new java.text.ParseException("JSON entity is not an object", 0);
    }

    @Deprecated
    public static JSONObject parseJSONObject(String s2) throws java.text.ParseException {
        return JSONObjectUtils.parse(s2);
    }

    private static <T> T getGeneric(JSONObject o2, String key, Class<T> clazz) throws java.text.ParseException {
        if (!o2.containsKey(key)) {
            throw new java.text.ParseException("Missing JSON object member with key \"" + key + "\"", 0);
        }
        if (o2.get(key) == null) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" has null value", 0);
        }
        Object value = o2.get(key);
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new java.text.ParseException("Unexpected type of JSON object member with key \"" + key + "\"", 0);
        }
        return (T)value;
    }

    public static boolean getBoolean(JSONObject o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Boolean.class);
    }

    public static int getInt(JSONObject o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class).intValue();
    }

    public static long getLong(JSONObject o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class).longValue();
    }

    public static float getFloat(JSONObject o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class).floatValue();
    }

    public static double getDouble(JSONObject o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, Number.class).doubleValue();
    }

    public static String getString(JSONObject o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, String.class);
    }

    public static URI getURI(JSONObject o2, String key) throws java.text.ParseException {
        try {
            return new URI(JSONObjectUtils.getGeneric(o2, key, String.class));
        }
        catch (URISyntaxException e2) {
            throw new java.text.ParseException(e2.getMessage(), 0);
        }
    }

    public static JSONArray getJSONArray(JSONObject o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, JSONArray.class);
    }

    public static String[] getStringArray(JSONObject o2, String key) throws java.text.ParseException {
        JSONArray jsonArray = JSONObjectUtils.getJSONArray(o2, key);
        try {
            return jsonArray.toArray(new String[0]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new java.text.ParseException("JSON object member with key \"" + key + "\" is not an array of strings", 0);
        }
    }

    public static List<String> getStringList(JSONObject o2, String key) throws java.text.ParseException {
        String[] array = JSONObjectUtils.getStringArray(o2, key);
        return Arrays.asList(array);
    }

    public static JSONObject getJSONObject(JSONObject o2, String key) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(o2, key, JSONObject.class);
    }

    private JSONObjectUtils() {
    }
}

