/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import java.util.Arrays;

final class Base64Codec {
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] CA_URL_SAFE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private static final int[] IA = new int[256];
    private static final int[] IA_URL_SAFE = new int[256];

    static {
        Arrays.fill(IA, -1);
        int i2 = 0;
        int iS = CA.length;
        while (i2 < iS) {
            Base64Codec.IA[Base64Codec.CA[i2]] = i2;
            ++i2;
        }
        Base64Codec.IA[61] = 0;
        Arrays.fill(IA_URL_SAFE, -1);
        i2 = 0;
        iS = CA_URL_SAFE.length;
        while (i2 < iS) {
            Base64Codec.IA_URL_SAFE[Base64Codec.CA_URL_SAFE[i2]] = i2;
            ++i2;
        }
        Base64Codec.IA_URL_SAFE[61] = 0;
    }

    Base64Codec() {
    }

    public static int computeEncodedLength(int inputLength, boolean urlSafe) {
        if (inputLength == 0) {
            return 0;
        }
        if (urlSafe) {
            int fullQuadLength = inputLength / 3 << 2;
            int remainder = inputLength % 3;
            return remainder == 0 ? fullQuadLength : fullQuadLength + remainder + 1;
        }
        return (inputLength - 1) / 3 + 1 << 2;
    }

    public static String normalizeEncodedString(String b64String) {
        int inputLen = b64String.length();
        int legalLen = inputLen - Base64Codec.countIllegalChars(b64String);
        int padLength = legalLen % 4 == 0 ? 0 : 4 - legalLen % 4;
        char[] chars = new char[inputLen + padLength];
        b64String.getChars(0, inputLen, chars, 0);
        int i2 = 0;
        while (i2 < padLength) {
            chars[inputLen + i2] = 61;
            ++i2;
        }
        i2 = 0;
        while (i2 < inputLen) {
            if (chars[i2] == '_') {
                chars[i2] = 47;
            } else if (chars[i2] == '-') {
                chars[i2] = 43;
            }
            ++i2;
        }
        return new String(chars);
    }

    public static int countIllegalChars(String b64String) {
        int illegalCharCount = 0;
        int i2 = 0;
        while (i2 < b64String.length()) {
            char c2 = b64String.charAt(i2);
            if (IA[c2] == -1 && IA_URL_SAFE[c2] == -1) {
                ++illegalCharCount;
            }
            ++i2;
        }
        return illegalCharCount;
    }

    public static char[] encodeToChar(byte[] byteArray, boolean urlSafe) {
        int sLen;
        int n2 = sLen = byteArray != null ? byteArray.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int dLen = Base64Codec.computeEncodedLength(sLen, urlSafe);
        char[] out = new char[dLen];
        int s2 = 0;
        int d2 = 0;
        while (s2 < eLen) {
            int i2 = (byteArray[s2++] & 0xFF) << 16 | (byteArray[s2++] & 0xFF) << 8 | byteArray[s2++] & 0xFF;
            if (urlSafe) {
                out[d2++] = CA_URL_SAFE[i2 >>> 18 & 0x3F];
                out[d2++] = CA_URL_SAFE[i2 >>> 12 & 0x3F];
                out[d2++] = CA_URL_SAFE[i2 >>> 6 & 0x3F];
                out[d2++] = CA_URL_SAFE[i2 & 0x3F];
                continue;
            }
            out[d2++] = CA[i2 >>> 18 & 0x3F];
            out[d2++] = CA[i2 >>> 12 & 0x3F];
            out[d2++] = CA[i2 >>> 6 & 0x3F];
            out[d2++] = CA[i2 & 0x3F];
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i3 = (byteArray[eLen] & 0xFF) << 10 | (left == 2 ? (byteArray[sLen - 1] & 0xFF) << 2 : 0);
            if (urlSafe) {
                if (left == 2) {
                    out[dLen - 3] = CA_URL_SAFE[i3 >> 12];
                    out[dLen - 2] = CA_URL_SAFE[i3 >>> 6 & 0x3F];
                    out[dLen - 1] = CA_URL_SAFE[i3 & 0x3F];
                } else {
                    out[dLen - 2] = CA_URL_SAFE[i3 >> 12];
                    out[dLen - 1] = CA_URL_SAFE[i3 >>> 6 & 0x3F];
                }
            } else {
                out[dLen - 4] = CA[i3 >> 12];
                out[dLen - 3] = CA[i3 >>> 6 & 0x3F];
                out[dLen - 2] = left == 2 ? CA[i3 & 0x3F] : 61;
                out[dLen - 1] = 61;
            }
        }
        return out;
    }

    public static String encodeToString(byte[] byteArray, boolean urlSafe) {
        return new String(Base64Codec.encodeToChar(byteArray, urlSafe));
    }

    public static byte[] decode(String b64String) {
        int sepCnt;
        if (b64String == null || b64String.isEmpty()) {
            return new byte[0];
        }
        String nStr = Base64Codec.normalizeEncodedString(b64String);
        int sLen = nStr.length();
        if ((sLen - (sepCnt = Base64Codec.countIllegalChars(nStr))) % 4 != 0) {
            return new byte[0];
        }
        int pad = 0;
        int i2 = sLen;
        while (i2 > 1 && IA[nStr.charAt(--i2)] <= 0) {
            if (nStr.charAt(i2) != '=') continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s2 = 0;
        int d2 = 0;
        while (d2 < len) {
            int i3 = 0;
            int j2 = 0;
            while (j2 < 4) {
                int c2;
                if ((c2 = IA[nStr.charAt(s2++)]) >= 0) {
                    i3 |= c2 << 18 - j2 * 6;
                } else {
                    --j2;
                }
                ++j2;
            }
            dArr[d2++] = (byte)(i3 >> 16);
            if (d2 >= len) continue;
            dArr[d2++] = (byte)(i3 >> 8);
            if (d2 >= len) continue;
            dArr[d2++] = (byte)i3;
        }
        return dArr;
    }
}

