/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import java.text.ParseException;

public enum KeyUse {
    SIGNATURE("sig"),
    ENCRYPTION("enc");

    private final String identifier;

    private KeyUse(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("The key use identifier must not be null");
        }
        this.identifier = identifier;
    }

    public String identifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier();
    }

    public static KeyUse parse(String s2) throws ParseException {
        if (s2 == null) {
            return null;
        }
        KeyUse[] keyUseArray = KeyUse.values();
        int n2 = keyUseArray.length;
        int n3 = 0;
        while (n3 < n2) {
            KeyUse use = keyUseArray[n3];
            if (s2.equals(use.identifier)) {
                return use;
            }
            ++n3;
        }
        throw new ParseException("Invalid JWK use: " + s2, 0);
    }
}

