/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.X509CertChainUtils;
import java.net.URI;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import net.minidev.json.JSONObject;

final class JWKMetadata {
    JWKMetadata() {
    }

    public static KeyType parseKeyType(JSONObject o2) throws ParseException {
        return KeyType.parse(JSONObjectUtils.getString(o2, "kty"));
    }

    public static KeyUse parseKeyUse(JSONObject o2) throws ParseException {
        if (o2.containsKey("use")) {
            return KeyUse.parse(JSONObjectUtils.getString(o2, "use"));
        }
        return null;
    }

    public static Set<KeyOperation> parseKeyOperations(JSONObject o2) throws ParseException {
        if (o2.containsKey("key_ops")) {
            return KeyOperation.parse(JSONObjectUtils.getStringList(o2, "key_ops"));
        }
        return null;
    }

    public static Algorithm parseAlgorithm(JSONObject o2) throws ParseException {
        if (o2.containsKey("alg")) {
            return new Algorithm(JSONObjectUtils.getString(o2, "alg"));
        }
        return null;
    }

    public static String parseKeyID(JSONObject o2) throws ParseException {
        if (o2.containsKey("kid")) {
            return JSONObjectUtils.getString(o2, "kid");
        }
        return null;
    }

    public static URI parseX509CertURL(JSONObject o2) throws ParseException {
        if (o2.containsKey("x5u")) {
            return JSONObjectUtils.getURI(o2, "x5u");
        }
        return null;
    }

    public static Base64URL parseX509CertThumbprint(JSONObject o2) throws ParseException {
        if (o2.containsKey("x5t")) {
            return new Base64URL(JSONObjectUtils.getString(o2, "x5t"));
        }
        return null;
    }

    public static List<Base64> parseX509CertChain(JSONObject o2) throws ParseException {
        if (o2.containsKey("x5c")) {
            return X509CertChainUtils.parseX509CertChain(JSONObjectUtils.getJSONArray(o2, "x5c"));
        }
        return null;
    }
}

