/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.crypto.HMAC;
import com.nimbusds.jose.crypto.PRFParams;
import com.nimbusds.jose.util.ByteUtils;
import com.nimbusds.jose.util.IntegerUtils;
import com.nimbusds.jose.util.StandardCharset;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class PBKDF2 {
    public static byte[] ZERO_BYTE = new byte[1];

    public static byte[] formatSalt(JWEAlgorithm alg, byte[] salt) throws JOSEException {
        byte[] algBytes = alg.toString().getBytes(StandardCharset.UTF_8);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(algBytes);
            out.write(ZERO_BYTE);
            out.write(salt);
        }
        catch (IOException e2) {
            throw new JOSEException(e2.getMessage(), e2);
        }
        return out.toByteArray();
    }

    public static SecretKey deriveKey(byte[] password, byte[] formattedSalt, int iterationCount, PRFParams prfParams) throws JOSEException {
        SecretKeySpec macKey = new SecretKeySpec(password, prfParams.getMACAlgorithm());
        Mac prf = HMAC.getInitMac(macKey, prfParams.getMacProvider());
        int hLen = prf.getMacLength();
        long maxDerivedKeyLength = 0xFFFFFFFFL;
        if ((long)prfParams.getDerivedKeyByteLength() > maxDerivedKeyLength) {
            throw new JOSEException("derived key too long " + prfParams.getDerivedKeyByteLength());
        }
        int l2 = (int)Math.ceil((double)prfParams.getDerivedKeyByteLength() / (double)hLen);
        int r2 = prfParams.getDerivedKeyByteLength() - (l2 - 1) * hLen;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int i2 = 0;
        while (i2 < l2) {
            byte[] block = PBKDF2.extractBlock(formattedSalt, iterationCount, i2 + 1, prf);
            if (i2 == l2 - 1) {
                block = ByteUtils.subArray(block, 0, r2);
            }
            byteArrayOutputStream.write(block, 0, block.length);
            ++i2;
        }
        return new SecretKeySpec(byteArrayOutputStream.toByteArray(), "AES");
    }

    private static byte[] extractBlock(byte[] salt, int iterationCount, int blockIndex, Mac prf) {
        byte[] lastU = null;
        byte[] xorU = null;
        int i2 = 1;
        while (i2 <= iterationCount) {
            byte[] currentU;
            if (i2 == 1) {
                byte[] inputBytes = ByteUtils.concat(salt, IntegerUtils.toBytes(blockIndex));
                xorU = currentU = prf.doFinal(inputBytes);
            } else {
                currentU = prf.doFinal(lastU);
                int j2 = 0;
                while (j2 < currentU.length) {
                    xorU[j2] = (byte)(currentU[j2] ^ xorU[j2]);
                    ++j2;
                }
            }
            lastU = currentU;
            ++i2;
        }
        return xorU;
    }

    private PBKDF2() {
    }
}

