/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.CriticalHeaderParamsAware;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.AESKW;
import com.nimbusds.jose.crypto.ContentCryptoProvider;
import com.nimbusds.jose.crypto.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.crypto.ECDH;
import com.nimbusds.jose.crypto.ECDHCryptoProvider;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.util.Base64URL;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Set;
import javax.crypto.SecretKey;

public class ECDHDecrypter
extends ECDHCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final ECPrivateKey privateKey;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public ECDHDecrypter(ECPrivateKey privateKey) throws JOSEException {
        this(privateKey, null);
    }

    public ECDHDecrypter(ECKey ecJWK) throws JOSEException {
        super(ecJWK.getCurve());
        if (!ecJWK.isPrivate()) {
            throw new JOSEException("The EC JWK doesn't contain a private part");
        }
        this.privateKey = ecJWK.toECPrivateKey();
    }

    public ECDHDecrypter(ECPrivateKey privateKey, Set<String> defCritHeaders) throws JOSEException {
        super(ECKey.Curve.forECParameterSpec(privateKey.getParams()));
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
        this.privateKey = privateKey;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv2, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        SecretKey cek;
        JWEAlgorithm alg = header.getAlgorithm();
        ECDH.AlgorithmMode algMode = ECDH.resolveAlgorithmMode(alg);
        this.critPolicy.ensureHeaderPasses(header);
        ECKey ephemeralKey = header.getEphemeralPublicKey();
        if (ephemeralKey == null) {
            throw new JOSEException("Missing ephemeral public EC key \"epk\" JWE header parameter");
        }
        ECPublicKey ephemeralPublicKey = ephemeralKey.toECPublicKey();
        SecretKey Z = ECDH.deriveSharedSecret(ephemeralPublicKey, this.privateKey, this.getJCAContext().getKeyEncryptionProvider());
        this.getConcatKDF().getJCAContext().setProvider(this.getJCAContext().getMACProvider());
        SecretKey sharedKey = ECDH.deriveSharedKey(header, Z, this.getConcatKDF());
        if (algMode.equals((Object)ECDH.AlgorithmMode.DIRECT)) {
            cek = sharedKey;
        } else if (algMode.equals((Object)ECDH.AlgorithmMode.KW)) {
            if (encryptedKey == null) {
                throw new JOSEException("Missing JWE encrypted key");
            }
            cek = AESKW.unwrapCEK(sharedKey, encryptedKey.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException("Unexpected JWE ECDH algorithm mode: " + (Object)((Object)algMode));
        }
        return ContentCryptoProvider.decrypt(header, encryptedKey, iv2, cipherText, authTag, cek, this.getJCAContext());
    }
}

