/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.util;

import com.mchange.v1.util.AbstractMapEntry;
import com.mchange.v1.util.WrapperIterator;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DoubleWeakHashMap
implements Map {
    HashMap inner;
    ReferenceQueue keyQ = new ReferenceQueue();
    ReferenceQueue valQ = new ReferenceQueue();
    CheckKeyHolder holder = new CheckKeyHolder();
    Set userKeySet = null;
    Collection valuesCollection = null;
    static /* synthetic */ Class class$com$mchange$v2$util$DoubleWeakHashMap;

    public DoubleWeakHashMap() {
        this.inner = new HashMap();
    }

    public DoubleWeakHashMap(int initialCapacity) {
        this.inner = new HashMap(initialCapacity);
    }

    public DoubleWeakHashMap(int initialCapacity, float loadFactor) {
        this.inner = new HashMap(initialCapacity, loadFactor);
    }

    public DoubleWeakHashMap(Map m2) {
        this();
        this.putAll(m2);
    }

    public void cleanCleared() {
        WVal wv;
        WKey wk;
        while ((wk = (WKey)this.keyQ.poll()) != null) {
            this.inner.remove(wk);
        }
        while ((wv = (WVal)this.valQ.poll()) != null) {
            this.inner.remove(wv.getWKey());
        }
    }

    public void clear() {
        this.cleanCleared();
        this.inner.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        this.cleanCleared();
        try {
            boolean bl2 = this.inner.containsKey(this.holder.set(key));
            return bl2;
        }
        finally {
            this.holder.clear();
        }
    }

    public boolean containsValue(Object val) {
        Iterator ii2 = this.inner.values().iterator();
        while (ii2.hasNext()) {
            WVal wval = (WVal)ii2.next();
            if (!val.equals(wval.get())) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        this.cleanCleared();
        return new UserEntrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        try {
            this.cleanCleared();
            WVal wval = (WVal)this.inner.get(this.holder.set(key));
            Object var3_3 = wval == null ? null : wval.get();
            return var3_3;
        }
        finally {
            this.holder.clear();
        }
    }

    public boolean isEmpty() {
        this.cleanCleared();
        return this.inner.isEmpty();
    }

    public Set keySet() {
        this.cleanCleared();
        if (this.userKeySet == null) {
            this.userKeySet = new UserKeySet();
        }
        return this.userKeySet;
    }

    public Object put(Object key, Object val) {
        this.cleanCleared();
        WVal wout = this.doPut(key, val);
        if (wout != null) {
            return wout.get();
        }
        return null;
    }

    private WVal doPut(Object key, Object val) {
        WKey wk = new WKey(key, this.keyQ);
        WVal wv = new WVal(wk, val, this.valQ);
        return this.inner.put(wk, wv);
    }

    public void putAll(Map m2) {
        this.cleanCleared();
        Iterator ii2 = m2.entrySet().iterator();
        while (ii2.hasNext()) {
            Map.Entry entry = ii2.next();
            this.doPut(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        try {
            this.cleanCleared();
            WVal wv = (WVal)this.inner.remove(this.holder.set(key));
            Object var3_3 = wv == null ? null : wv.get();
            return var3_3;
        }
        finally {
            this.holder.clear();
        }
    }

    public int size() {
        this.cleanCleared();
        return this.inner.size();
    }

    public Collection values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new ValuesCollection();
        }
        return this.valuesCollection;
    }

    class ValuesCollection
    implements Collection {
        ValuesCollection() {
        }

        public boolean add(Object o2) {
            DoubleWeakHashMap.this.cleanCleared();
            throw new UnsupportedOperationException("DoubleWeakHashMap does not support adding to its values Collection.");
        }

        public boolean addAll(Collection c2) {
            DoubleWeakHashMap.this.cleanCleared();
            throw new UnsupportedOperationException("DoubleWeakHashMap does not support adding to its values Collection.");
        }

        public void clear() {
            DoubleWeakHashMap.this.clear();
        }

        public boolean contains(Object o2) {
            return DoubleWeakHashMap.this.containsValue(o2);
        }

        public boolean containsAll(Collection c2) {
            Iterator ii2 = c2.iterator();
            while (ii2.hasNext()) {
                if (this.contains(ii2.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return DoubleWeakHashMap.this.isEmpty();
        }

        public Iterator iterator() {
            return new WrapperIterator(DoubleWeakHashMap.this.inner.values().iterator(), true){

                protected Object transformObject(Object o2) {
                    Object val = ((WVal)o2).get();
                    if (val == null) {
                        return WrapperIterator.SKIP_TOKEN;
                    }
                    return val;
                }
            };
        }

        public boolean remove(Object o2) {
            DoubleWeakHashMap.this.cleanCleared();
            return this.removeValue(o2);
        }

        public boolean removeAll(Collection c2) {
            DoubleWeakHashMap.this.cleanCleared();
            boolean out = false;
            Iterator ii2 = c2.iterator();
            while (ii2.hasNext()) {
                out |= this.removeValue(ii2.next());
            }
            return out;
        }

        public boolean retainAll(Collection c2) {
            DoubleWeakHashMap.this.cleanCleared();
            return this.retainValues(c2);
        }

        public int size() {
            return DoubleWeakHashMap.this.size();
        }

        public Object[] toArray() {
            DoubleWeakHashMap.this.cleanCleared();
            return new ArrayList(this).toArray();
        }

        public Object[] toArray(Object[] array) {
            DoubleWeakHashMap.this.cleanCleared();
            return new ArrayList(this).toArray(array);
        }

        private boolean removeValue(Object val) {
            boolean out = false;
            Iterator ii2 = DoubleWeakHashMap.this.inner.values().iterator();
            while (ii2.hasNext()) {
                WVal wv = (WVal)ii2.next();
                if (!val.equals(wv.get())) continue;
                ii2.remove();
                out = true;
            }
            return out;
        }

        private boolean retainValues(Collection c2) {
            boolean out = false;
            Iterator ii2 = DoubleWeakHashMap.this.inner.values().iterator();
            while (ii2.hasNext()) {
                WVal wv = (WVal)ii2.next();
                if (c2.contains(wv.get())) continue;
                ii2.remove();
                out = true;
            }
            return out;
        }
    }

    class UserKeySet
    implements Set {
        UserKeySet() {
        }

        public boolean add(Object o2) {
            DoubleWeakHashMap.this.cleanCleared();
            throw new UnsupportedOperationException("You cannot add to a Map's key set.");
        }

        public boolean addAll(Collection c2) {
            DoubleWeakHashMap.this.cleanCleared();
            throw new UnsupportedOperationException("You cannot add to a Map's key set.");
        }

        public void clear() {
            DoubleWeakHashMap.this.clear();
        }

        public boolean contains(Object o2) {
            return DoubleWeakHashMap.this.containsKey(o2);
        }

        public boolean containsAll(Collection c2) {
            Iterator ii2 = c2.iterator();
            while (ii2.hasNext()) {
                if (this.contains(ii2.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return DoubleWeakHashMap.this.isEmpty();
        }

        public Iterator iterator() {
            DoubleWeakHashMap.this.cleanCleared();
            return new WrapperIterator(DoubleWeakHashMap.this.inner.keySet().iterator(), true){

                protected Object transformObject(Object o2) {
                    Object key = ((WKey)o2).get();
                    if (key == null) {
                        return WrapperIterator.SKIP_TOKEN;
                    }
                    return key;
                }
            };
        }

        public boolean remove(Object o2) {
            return DoubleWeakHashMap.this.remove(o2) != null;
        }

        public boolean removeAll(Collection c2) {
            boolean out = false;
            Iterator ii2 = c2.iterator();
            while (ii2.hasNext()) {
                out |= this.remove(ii2.next());
            }
            return out;
        }

        public boolean retainAll(Collection c2) {
            boolean out = false;
            Iterator ii2 = this.iterator();
            while (ii2.hasNext()) {
                if (c2.contains(ii2.next())) continue;
                ii2.remove();
                out = true;
            }
            return out;
        }

        public int size() {
            return DoubleWeakHashMap.this.size();
        }

        public Object[] toArray() {
            DoubleWeakHashMap.this.cleanCleared();
            return new HashSet(this).toArray();
        }

        public Object[] toArray(Object[] array) {
            DoubleWeakHashMap.this.cleanCleared();
            return new HashSet(this).toArray(array);
        }
    }

    class UserEntry
    extends AbstractMapEntry {
        Map.Entry innerEntry;
        Object key;
        Object val;

        UserEntry(Map.Entry innerEntry, Object key, Object value) {
            this.innerEntry = innerEntry;
            this.key = key;
            this.val = this.val;
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.val;
        }

        public final Object setValue(Object value) {
            return this.innerEntry.setValue(new WVal((WKey)this.innerEntry.getKey(), value, DoubleWeakHashMap.this.valQ));
        }
    }

    private final class UserEntrySet
    extends AbstractSet {
        private UserEntrySet() {
        }

        private Set innerEntrySet() {
            DoubleWeakHashMap.this.cleanCleared();
            return DoubleWeakHashMap.this.inner.entrySet();
        }

        public Iterator iterator() {
            return new WrapperIterator(this.innerEntrySet().iterator(), true){

                protected Object transformObject(Object o2) {
                    Map.Entry innerEntry = (Map.Entry)o2;
                    Object key = ((WKey)innerEntry.getKey()).get();
                    Object val = ((WVal)innerEntry.getValue()).get();
                    if (key == null || val == null) {
                        return WrapperIterator.SKIP_TOKEN;
                    }
                    return new UserEntry(innerEntry, key, val);
                }
            };
        }

        public int size() {
            return this.innerEntrySet().size();
        }
    }

    static final class WVal
    extends WeakReference {
        WKey key;

        WVal(WKey key, Object valObj, ReferenceQueue rq) {
            super(valObj, rq);
            this.key = key;
        }

        public WKey getWKey() {
            return this.key;
        }
    }

    static final class WKey
    extends WeakReference {
        int cachedHash;

        WKey(Object keyObj, ReferenceQueue rq) {
            super(keyObj, rq);
            this.cachedHash = keyObj.hashCode();
        }

        public int hashCode() {
            return this.cachedHash;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 instanceof WKey) {
                WKey oo = (WKey)o2;
                Object myVal = this.get();
                Object ooVal = oo.get();
                if (myVal == null || ooVal == null) {
                    return false;
                }
                return myVal.equals(ooVal);
            }
            if (o2 instanceof CheckKeyHolder) {
                CheckKeyHolder oo = (CheckKeyHolder)o2;
                Object myVal = this.get();
                Object ooVal = oo.get();
                if (myVal == null || ooVal == null) {
                    return false;
                }
                return myVal.equals(ooVal);
            }
            return false;
        }
    }

    static final class CheckKeyHolder {
        Object checkKey;
        static final /* synthetic */ boolean $assertionsDisabled;

        CheckKeyHolder() {
        }

        public Object get() {
            return this.checkKey;
        }

        public CheckKeyHolder set(Object ck2) {
            if (!$assertionsDisabled && this.checkKey != null) {
                throw new AssertionError((Object)"Illegal concurrenct use of DoubleWeakHashMap!");
            }
            this.checkKey = ck2;
            return this;
        }

        public void clear() {
            this.checkKey = null;
        }

        public int hashCode() {
            return this.checkKey.hashCode();
        }

        public boolean equals(Object o2) {
            if (!$assertionsDisabled && this.get() == null) {
                throw new AssertionError((Object)"CheckedKeyHolder should never do an equality check while its value is null.");
            }
            if (this == o2) {
                return true;
            }
            if (o2 instanceof CheckKeyHolder) {
                return this.get().equals(((CheckKeyHolder)o2).get());
            }
            if (o2 instanceof WKey) {
                return this.get().equals(((WKey)o2).get());
            }
            return false;
        }

        static {
            $assertionsDisabled = !(class$com$mchange$v2$util$DoubleWeakHashMap == null ? (class$com$mchange$v2$util$DoubleWeakHashMap = DoubleWeakHashMap.class$("com.mchange.v2.util.DoubleWeakHashMap")) : class$com$mchange$v2$util$DoubleWeakHashMap).desiredAssertionStatus();
        }
    }
}

