/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log.jdk14logging;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.DoubleWeakHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Jdk14MLog
extends MLog {
    private static String[] UNKNOWN_ARRAY = new String[]{"UNKNOWN_CLASS", "UNKNOWN_METHOD"};
    private static final String CHECK_CLASS = "java.util.logging.Logger";
    private final Map namedLoggerMap = new DoubleWeakHashMap();
    MLogger global = null;

    public Jdk14MLog() throws ClassNotFoundException {
        Class.forName(CHECK_CLASS);
    }

    public synchronized MLogger getMLogger(String name) {
        MLogger out = (MLogger)this.namedLoggerMap.get(name = name.intern());
        if (out == null) {
            Logger lg = Logger.getLogger(name);
            out = new Jdk14MLogger(lg);
            this.namedLoggerMap.put(name, out);
        }
        return out;
    }

    public synchronized MLogger getMLogger(Class cl2) {
        return Jdk14MLog.getLogger(cl2.getName());
    }

    public synchronized MLogger getMLogger() {
        if (this.global == null) {
            this.global = new Jdk14MLogger(LogManager.getLogManager().getLogger("global"));
        }
        return this.global;
    }

    private static String[] findCallingClassAndMethod() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        int len = ste.length;
        for (int i2 = 0; i2 < len; ++i2) {
            StackTraceElement check = ste[i2];
            String cn2 = check.getClassName();
            if (cn2 == null || cn2.startsWith("com.mchange.v2.log.jdk14logging")) continue;
            return new String[]{check.getClassName(), check.getMethodName()};
        }
        return UNKNOWN_ARRAY;
    }

    private static final class Jdk14MLogger
    implements MLogger {
        volatile Logger logger;

        Jdk14MLogger(Logger logger) {
            this.logger = logger;
        }

        private static Level level(MLevel lvl) {
            return (Level)lvl.asJdk14Level();
        }

        public ResourceBundle getResourceBundle() {
            return this.logger.getResourceBundle();
        }

        public String getResourceBundleName() {
            return this.logger.getResourceBundleName();
        }

        public void setFilter(Object java14Filter) throws SecurityException {
            if (!(java14Filter instanceof Filter)) {
                throw new IllegalArgumentException("MLogger.setFilter( ... ) requires a java.util.logging.Filter. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.setFilter((Filter)java14Filter);
        }

        public Object getFilter() {
            return this.logger.getFilter();
        }

        public void log(MLevel l2, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(l2), sa[0], sa[1], msg);
        }

        public void log(MLevel l2, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(l2), sa[0], sa[1], msg, param);
        }

        public void log(MLevel l2, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(l2), sa[0], sa[1], msg, params);
        }

        public void log(MLevel l2, String msg, Throwable t2) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(l2), sa[0], sa[1], msg, t2);
        }

        public void logp(MLevel l2, String srcClass, String srcMeth, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l2), srcClass, srcMeth, msg);
        }

        public void logp(MLevel l2, String srcClass, String srcMeth, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l2), srcClass, srcMeth, msg, param);
        }

        public void logp(MLevel l2, String srcClass, String srcMeth, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l2), srcClass, srcMeth, msg, params);
        }

        public void logp(MLevel l2, String srcClass, String srcMeth, String msg, Throwable t2) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l2), srcClass, srcMeth, msg, t2);
        }

        public void logrb(MLevel l2, String srcClass, String srcMeth, String rb, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l2), srcClass, srcMeth, rb, msg);
        }

        public void logrb(MLevel l2, String srcClass, String srcMeth, String rb, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l2), srcClass, srcMeth, rb, msg, param);
        }

        public void logrb(MLevel l2, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l2), srcClass, srcMeth, rb, msg, params);
        }

        public void logrb(MLevel l2, String srcClass, String srcMeth, String rb, String msg, Throwable t2) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l2))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l2), srcClass, srcMeth, rb, msg, t2);
        }

        public void entering(String srcClass, String srcMeth) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth);
        }

        public void entering(String srcClass, String srcMeth, Object param) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth, param);
        }

        public void entering(String srcClass, String srcMeth, Object[] params) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth, params);
        }

        public void exiting(String srcClass, String srcMeth) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.exiting(srcClass, srcMeth);
        }

        public void exiting(String srcClass, String srcMeth, Object result) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.exiting(srcClass, srcMeth, result);
        }

        public void throwing(String srcClass, String srcMeth, Throwable t2) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.throwing(srcClass, srcMeth, t2);
        }

        public void severe(String msg) {
            if (!this.logger.isLoggable(Level.SEVERE)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.SEVERE, sa[0], sa[1], msg);
        }

        public void warning(String msg) {
            if (!this.logger.isLoggable(Level.WARNING)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.WARNING, sa[0], sa[1], msg);
        }

        public void info(String msg) {
            if (!this.logger.isLoggable(Level.INFO)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.INFO, sa[0], sa[1], msg);
        }

        public void config(String msg) {
            if (!this.logger.isLoggable(Level.CONFIG)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.CONFIG, sa[0], sa[1], msg);
        }

        public void fine(String msg) {
            if (!this.logger.isLoggable(Level.FINE)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINE, sa[0], sa[1], msg);
        }

        public void finer(String msg) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINER, sa[0], sa[1], msg);
        }

        public void finest(String msg) {
            if (!this.logger.isLoggable(Level.FINEST)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINEST, sa[0], sa[1], msg);
        }

        public void setLevel(MLevel l2) throws SecurityException {
            this.logger.setLevel(Jdk14MLogger.level(l2));
        }

        public MLevel getLevel() {
            return MLevel.fromIntValue(this.logger.getLevel().intValue());
        }

        public boolean isLoggable(MLevel l2) {
            return this.logger.isLoggable(Jdk14MLogger.level(l2));
        }

        public String getName() {
            return this.logger.getName();
        }

        public void addHandler(Object h2) throws SecurityException {
            if (!(h2 instanceof Handler)) {
                throw new IllegalArgumentException("MLogger.addHandler( ... ) requires a java.util.logging.Handler. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.addHandler((Handler)h2);
        }

        public void removeHandler(Object h2) throws SecurityException {
            if (!(h2 instanceof Handler)) {
                throw new IllegalArgumentException("MLogger.removeHandler( ... ) requires a java.util.logging.Handler. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.removeHandler((Handler)h2);
        }

        public Object[] getHandlers() {
            return this.logger.getHandlers();
        }

        public void setUseParentHandlers(boolean uph) {
            this.logger.setUseParentHandlers(uph);
        }

        public boolean getUseParentHandlers() {
            return this.logger.getUseParentHandlers();
        }
    }
}

