/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentedWriter
extends FilterWriter {
    static final String EOL;
    int indent_level = 0;
    boolean at_line_start = true;

    public IndentedWriter(Writer out) {
        super(out);
    }

    private boolean isEol(char c2) {
        return c2 == '\r' || c2 == '\n';
    }

    public void upIndent() {
        ++this.indent_level;
    }

    public void downIndent() {
        --this.indent_level;
    }

    public void write(int c2) throws IOException {
        this.out.write(c2);
        this.at_line_start = this.isEol((char)c2);
    }

    public void write(char[] chars, int off, int len) throws IOException {
        this.out.write(chars, off, len);
        this.at_line_start = this.isEol(chars[off + len - 1]);
    }

    public void write(String s2, int off, int len) throws IOException {
        if (len > 0) {
            this.out.write(s2, off, len);
            this.at_line_start = this.isEol(s2.charAt(off + len - 1));
        }
    }

    private void printIndent() throws IOException {
        for (int i2 = 0; i2 < this.indent_level; ++i2) {
            this.out.write(9);
        }
    }

    public void print(String s2) throws IOException {
        if (this.at_line_start) {
            this.printIndent();
        }
        this.out.write(s2);
        char last = s2.charAt(s2.length() - 1);
        this.at_line_start = this.isEol(last);
    }

    public void println(String s2) throws IOException {
        if (this.at_line_start) {
            this.printIndent();
        }
        this.out.write(s2);
        this.out.write(EOL);
        this.at_line_start = true;
    }

    public void print(boolean x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void print(byte x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void print(char x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void print(short x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void print(int x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void print(long x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void print(float x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void print(double x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void print(Object x2) throws IOException {
        this.print(String.valueOf(x2));
    }

    public void println(boolean x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println(byte x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println(char x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println(short x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println(int x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println(long x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println(float x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println(double x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println(Object x2) throws IOException {
        this.println(String.valueOf(x2));
    }

    public void println() throws IOException {
        this.println("");
    }

    static {
        String eol = System.getProperty("line.separator");
        EOL = eol != null ? eol : "\r\n";
    }
}

