/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.debug;

import com.mchange.lang.ThrowableUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ThreadNameStackTraceRecorder {
    static final String NL = System.getProperty("line.separator", "\r\n");
    Set set = new HashSet();
    String dumpHeader;
    String stackTraceHeader;

    public ThreadNameStackTraceRecorder(String dumpHeader) {
        this(dumpHeader, "Debug Stack Trace.");
    }

    public ThreadNameStackTraceRecorder(String dumpHeader, String stackTraceHeader) {
        this.dumpHeader = dumpHeader;
        this.stackTraceHeader = stackTraceHeader;
    }

    public synchronized Object record() {
        Record r2 = new Record(this.stackTraceHeader);
        this.set.add(r2);
        return r2;
    }

    public synchronized void remove(Object rec) {
        this.set.remove(rec);
    }

    public synchronized int size() {
        return this.set.size();
    }

    public synchronized String getDump() {
        return this.getDump(null);
    }

    public synchronized String getDump(String locationSpecificNote) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMMM-yyyy HH:mm:ss.SSSS");
        StringBuffer sb = new StringBuffer(2047);
        sb.append(NL);
        sb.append("----------------------------------------------------");
        sb.append(NL);
        sb.append(this.dumpHeader);
        sb.append(NL);
        if (locationSpecificNote != null) {
            sb.append(locationSpecificNote);
            sb.append(NL);
        }
        boolean first = true;
        Iterator ii2 = this.set.iterator();
        while (ii2.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append("---");
                sb.append(NL);
            }
            Record r2 = (Record)ii2.next();
            sb.append(df2.format(new Date(r2.time)));
            sb.append(" --> Thread Name: ");
            sb.append(r2.threadName);
            sb.append(NL);
            sb.append("Stack Trace: ");
            sb.append(ThrowableUtils.extractStackTrace(r2.stackTrace));
        }
        sb.append("----------------------------------------------------");
        sb.append(NL);
        return sb.toString();
    }

    private static final class Record
    implements Comparable {
        long time = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        Throwable stackTrace;

        Record(String sth) {
            this.stackTrace = new Exception(sth);
        }

        public int compareTo(Object o2) {
            int yours;
            Record oo = (Record)o2;
            if (this.time > oo.time) {
                return 1;
            }
            if (this.time < oo.time) {
                return -1;
            }
            int mine = System.identityHashCode(this);
            if (mine > (yours = System.identityHashCode(oo))) {
                return 1;
            }
            if (mine < yours) {
                return -1;
            }
            return 0;
        }
    }
}

