/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SerializableExtension
implements GeneratorExtension {
    Set transientProperties;
    Map transientPropertyInitializers;

    public SerializableExtension(Set transientProperties, Map transientPropertyInitializers) {
        this.transientProperties = transientProperties;
        this.transientPropertyInitializers = transientPropertyInitializers;
    }

    public SerializableExtension() {
        this(Collections.EMPTY_SET, null);
    }

    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraSpecificImports() {
        HashSet<String> set = new HashSet<String>();
        set.add("java.io.IOException");
        set.add("java.io.Serializable");
        set.add("java.io.ObjectOutputStream");
        set.add("java.io.ObjectInputStream");
        return set;
    }

    public Collection extraInterfaceNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("Serializable");
        return set;
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
        Class propType;
        Property prop;
        int i2;
        iw2.println("private static final long serialVersionUID = 1;");
        iw2.println("private static final short VERSION = 0x0001;");
        iw2.println();
        iw2.println("private void writeObject( ObjectOutputStream oos ) throws IOException");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("oos.writeShort( VERSION );");
        int len = props.length;
        for (i2 = 0; i2 < len; ++i2) {
            prop = props[i2];
            if (this.transientProperties.contains(prop.getName())) continue;
            propType = propTypes[i2];
            if (propType != null && propType.isPrimitive()) {
                if (propType == Byte.TYPE) {
                    iw2.println("oos.writeByte(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Character.TYPE) {
                    iw2.println("oos.writeChar(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Short.TYPE) {
                    iw2.println("oos.writeShort(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Integer.TYPE) {
                    iw2.println("oos.writeInt(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Boolean.TYPE) {
                    iw2.println("oos.writeBoolean(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Long.TYPE) {
                    iw2.println("oos.writeLong(" + prop.getName() + ");");
                    continue;
                }
                if (propType == Float.TYPE) {
                    iw2.println("oos.writeFloat(" + prop.getName() + ");");
                    continue;
                }
                if (propType != Double.TYPE) continue;
                iw2.println("oos.writeDouble(" + prop.getName() + ");");
                continue;
            }
            this.writeStoreObject(prop, propType, iw2);
        }
        this.generateExtraSerWriteStatements(info, superclassType, props, propTypes, iw2);
        iw2.downIndent();
        iw2.println("}");
        iw2.println();
        iw2.println("private void readObject( ObjectInputStream ois ) throws IOException, ClassNotFoundException");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("short version = ois.readShort();");
        iw2.println("switch (version)");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("case VERSION:");
        iw2.upIndent();
        len = props.length;
        for (i2 = 0; i2 < len; ++i2) {
            prop = props[i2];
            if (!this.transientProperties.contains(prop.getName())) {
                propType = propTypes[i2];
                if (propType != null && propType.isPrimitive()) {
                    if (propType == Byte.TYPE) {
                        iw2.println("this." + prop.getName() + " = ois.readByte();");
                        continue;
                    }
                    if (propType == Character.TYPE) {
                        iw2.println("this." + prop.getName() + " = ois.readChar();");
                        continue;
                    }
                    if (propType == Short.TYPE) {
                        iw2.println("this." + prop.getName() + " = ois.readShort();");
                        continue;
                    }
                    if (propType == Integer.TYPE) {
                        iw2.println("this." + prop.getName() + " = ois.readInt();");
                        continue;
                    }
                    if (propType == Boolean.TYPE) {
                        iw2.println("this." + prop.getName() + " = ois.readBoolean();");
                        continue;
                    }
                    if (propType == Long.TYPE) {
                        iw2.println("this." + prop.getName() + " = ois.readLong();");
                        continue;
                    }
                    if (propType == Float.TYPE) {
                        iw2.println("this." + prop.getName() + " = ois.readFloat();");
                        continue;
                    }
                    if (propType != Double.TYPE) continue;
                    iw2.println("this." + prop.getName() + " = ois.readDouble();");
                    continue;
                }
                this.writeUnstoreObject(prop, propType, iw2);
                continue;
            }
            String initializer = (String)this.transientPropertyInitializers.get(prop.getName());
            if (initializer == null) continue;
            iw2.println("this." + prop.getName() + " = " + initializer + ';');
        }
        this.generateExtraSerInitializers(info, superclassType, props, propTypes, iw2);
        iw2.println("break;");
        iw2.downIndent();
        iw2.println("default:");
        iw2.upIndent();
        iw2.println("throw new IOException(\"Unsupported Serialized Version: \" + version);");
        iw2.downIndent();
        iw2.downIndent();
        iw2.println("}");
        iw2.downIndent();
        iw2.println("}");
    }

    protected void writeStoreObject(Property prop, Class propType, IndentedWriter iw2) throws IOException {
        iw2.println("oos.writeObject( " + prop.getName() + " );");
    }

    protected void writeUnstoreObject(Property prop, Class propType, IndentedWriter iw2) throws IOException {
        iw2.println("this." + prop.getName() + " = (" + prop.getSimpleTypeName() + ") ois.readObject();");
    }

    protected void generateExtraSerWriteStatements(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
    }

    protected void generateExtraSerInitializers(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
    }
}

