/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class PropertyMapConstructorGeneratorExtension
implements GeneratorExtension {
    int ctor_modifiers = 1;

    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraSpecificImports() {
        HashSet<String> set = new HashSet<String>();
        set.add("java.util.Map");
        return set;
    }

    public Collection extraInterfaceNames() {
        return Collections.EMPTY_SET;
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
        iw2.print(CodegenUtils.getModifierString(this.ctor_modifiers));
        iw2.print(' ' + info.getClassName() + "( Map map )");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("Object raw;");
        int len = props.length;
        for (int i2 = 0; i2 < len; ++i2) {
            Property prop = props[i2];
            String propName = prop.getName();
            Class propType = propTypes[i2];
            iw2.println("raw = map.get( \"" + propName + "\" );");
            iw2.println("if (raw != null)");
            iw2.println("{");
            iw2.upIndent();
            iw2.print("this." + propName + " = ");
            if (propType == Boolean.TYPE) {
                iw2.println("((Boolean) raw ).booleanValue();");
            } else if (propType == Byte.TYPE) {
                iw2.println("((Byte) raw ).byteValue();");
            } else if (propType == Character.TYPE) {
                iw2.println("((Character) raw ).charValue();");
            } else if (propType == Short.TYPE) {
                iw2.println("((Short) raw ).shortValue();");
            } else if (propType == Integer.TYPE) {
                iw2.println("((Integer) raw ).intValue();");
            } else if (propType == Long.TYPE) {
                iw2.println("((Long) raw ).longValue();");
            } else if (propType == Float.TYPE) {
                iw2.println("((Float) raw ).floatValue();");
            } else if (propType == Double.TYPE) {
                iw2.println("((Double) raw ).doubleValue();");
            }
            iw2.println("raw = null;");
            iw2.downIndent();
            iw2.println("}");
        }
        iw2.downIndent();
        iw2.println("}");
    }
}

