/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.Property;
import com.mchange.v2.codegen.bean.SerializableExtension;
import com.mchange.v2.ser.IndirectPolicy;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;

public class IndirectingSerializableExtension
extends SerializableExtension {
    protected String findIndirectorExpr;
    protected String indirectorClassName;

    public IndirectingSerializableExtension(String indirectorClassName) {
        this.indirectorClassName = indirectorClassName;
        this.findIndirectorExpr = "new " + indirectorClassName + "()";
    }

    protected IndirectingSerializableExtension() {
    }

    public Collection extraSpecificImports() {
        Collection col = super.extraSpecificImports();
        col.add(this.indirectorClassName);
        col.add("com.mchange.v2.ser.IndirectlySerialized");
        col.add("com.mchange.v2.ser.Indirector");
        col.add("com.mchange.v2.ser.SerializableUtils");
        col.add("java.io.NotSerializableException");
        return col;
    }

    protected IndirectPolicy indirectingPolicy(Property prop, Class propType) {
        if (Serializable.class.isAssignableFrom(propType)) {
            return IndirectPolicy.DEFINITELY_DIRECT;
        }
        return IndirectPolicy.INDIRECT_ON_EXCEPTION;
    }

    protected void writeInitializeIndirector(Property prop, Class propType, IndentedWriter iw2) throws IOException {
    }

    protected void writeExtraDeclarations(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
        super.generate(info, superclassType, props, propTypes, iw2);
        this.writeExtraDeclarations(info, superclassType, props, propTypes, iw2);
    }

    protected void writeStoreObject(Property prop, Class propType, IndentedWriter iw2) throws IOException {
        IndirectPolicy policy = this.indirectingPolicy(prop, propType);
        if (policy == IndirectPolicy.DEFINITELY_INDIRECT) {
            this.writeIndirectStoreObject(prop, propType, iw2);
        } else if (policy == IndirectPolicy.INDIRECT_ON_EXCEPTION) {
            iw2.println("try");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("//test serialize");
            iw2.println("SerializableUtils.toByteArray(" + prop.getName() + ");");
            super.writeStoreObject(prop, propType, iw2);
            iw2.downIndent();
            iw2.println("}");
            iw2.println("catch (NotSerializableException nse)");
            iw2.println("{");
            iw2.upIndent();
            this.writeIndirectStoreObject(prop, propType, iw2);
            iw2.downIndent();
            iw2.println("}");
        } else if (policy == IndirectPolicy.DEFINITELY_DIRECT) {
            super.writeStoreObject(prop, propType, iw2);
        } else {
            throw new InternalError("indirectingPolicy() overridden to return unknown policy: " + policy);
        }
    }

    protected void writeIndirectStoreObject(Property prop, Class propType, IndentedWriter iw2) throws IOException {
        iw2.println("try");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("Indirector indirector = " + this.findIndirectorExpr + ';');
        this.writeInitializeIndirector(prop, propType, iw2);
        iw2.println("oos.writeObject( indirector.indirectForm( " + prop.getName() + " ) );");
        iw2.downIndent();
        iw2.println("}");
        iw2.println("catch (IOException indirectionIOException)");
        iw2.println("{ throw indirectionIOException; }");
        iw2.println("catch (Exception indirectionOtherException)");
        iw2.println("{ throw new IOException(\"Problem indirectly serializing " + prop.getName() + ": \" + indirectionOtherException.toString() ); }");
    }

    protected void writeUnstoreObject(Property prop, Class propType, IndentedWriter iw2) throws IOException {
        IndirectPolicy policy = this.indirectingPolicy(prop, propType);
        if (policy == IndirectPolicy.DEFINITELY_INDIRECT || policy == IndirectPolicy.INDIRECT_ON_EXCEPTION) {
            iw2.println("Object o = ois.readObject();");
            iw2.println("if (o instanceof IndirectlySerialized) o = ((IndirectlySerialized) o).getObject();");
            iw2.println("this." + prop.getName() + " = (" + prop.getSimpleTypeName() + ") o;");
        } else if (policy == IndirectPolicy.DEFINITELY_DIRECT) {
            super.writeUnstoreObject(prop, propType, iw2);
        } else {
            throw new InternalError("indirectingPolicy() overridden to return unknown policy: " + policy);
        }
    }
}

