/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.BeangenUtils;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ExplicitPropsConstructorGeneratorExtension
implements GeneratorExtension {
    static final MLogger logger = MLog.getLogger(ExplicitPropsConstructorGeneratorExtension.class);
    String[] propNames;
    boolean skips_silently = false;
    int ctor_modifiers = 1;

    public ExplicitPropsConstructorGeneratorExtension() {
    }

    public ExplicitPropsConstructorGeneratorExtension(String[] propNames) {
        this.propNames = propNames;
    }

    public String[] getPropNames() {
        return (String[])this.propNames.clone();
    }

    public void setPropNames(String[] propNames) {
        this.propNames = (String[])propNames.clone();
    }

    public boolean isSkipsSilently() {
        return this.skips_silently;
    }

    public void setsSkipsSilently(boolean skips_silently) {
        this.skips_silently = skips_silently;
    }

    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraSpecificImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraInterfaceNames() {
        return Collections.EMPTY_SET;
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
        HashMap<String, Property> propNamesToProps = new HashMap<String, Property>();
        int len = props.length;
        for (int i2 = 0; i2 < len; ++i2) {
            propNamesToProps.put(props[i2].getName(), props[i2]);
        }
        ArrayList<Property> subPropsList = new ArrayList<Property>(this.propNames.length);
        int len2 = this.propNames.length;
        for (int i3 = 0; i3 < len2; ++i3) {
            Property p2 = (Property)propNamesToProps.get(this.propNames[i3]);
            if (p2 == null) {
                logger.warning("Could not include property '" + this.propNames[i3] + "' in explicit-props-constructor generated for bean class '" + info.getClassName() + "' because the property is not defined for the bean. Skipping.");
                continue;
            }
            subPropsList.add(p2);
        }
        if (subPropsList.size() > 0) {
            Property[] subProps = subPropsList.toArray(new Property[subPropsList.size()]);
            iw2.print(CodegenUtils.getModifierString(this.ctor_modifiers));
            iw2.print(info.getClassName() + "( ");
            BeangenUtils.writeArgList(subProps, true, iw2);
            iw2.println(" )");
            iw2.println("{");
            iw2.upIndent();
            int len3 = subProps.length;
            for (int i4 = 0; i4 < len3; ++i4) {
                iw2.print("this." + subProps[i4].getName() + " = ");
                String setExp = subProps[i4].getDefensiveCopyExpression();
                if (setExp == null) {
                    setExp = subProps[i4].getName();
                }
                iw2.println(setExp + ';');
            }
            iw2.downIndent();
            iw2.println("}");
        }
    }
}

