/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class CloneableExtension
implements GeneratorExtension {
    boolean export_public;
    boolean exception_swallowing;
    String mLoggerName = null;

    public boolean isExportPublic() {
        return this.export_public;
    }

    public void setExportPublic(boolean export_public) {
        this.export_public = export_public;
    }

    public boolean isExceptionSwallowing() {
        return this.exception_swallowing;
    }

    public void setExceptionSwallowing(boolean exception_swallowing) {
        this.exception_swallowing = exception_swallowing;
    }

    public String getMLoggerName() {
        return this.mLoggerName;
    }

    public void setMLoggerName(String mLoggerName) {
        this.mLoggerName = mLoggerName;
    }

    public CloneableExtension(boolean export_public, boolean exception_swallowing) {
        this.export_public = export_public;
        this.exception_swallowing = exception_swallowing;
    }

    public CloneableExtension() {
        this(true, false);
    }

    public Collection extraGeneralImports() {
        return this.mLoggerName == null ? Collections.EMPTY_SET : Arrays.asList("com.mchange.v2.log");
    }

    public Collection extraSpecificImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraInterfaceNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("Cloneable");
        return set;
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
        if (this.export_public) {
            iw2.print("public Object clone()");
            if (!this.exception_swallowing) {
                iw2.println(" throws CloneNotSupportedException");
            } else {
                iw2.println();
            }
            iw2.println("{");
            iw2.upIndent();
            if (this.exception_swallowing) {
                iw2.println("try");
                iw2.println("{");
                iw2.upIndent();
            }
            iw2.println("return super.clone();");
            if (this.exception_swallowing) {
                iw2.downIndent();
                iw2.println("}");
                iw2.println("catch (CloneNotSupportedException e)");
                iw2.println("{");
                iw2.upIndent();
                if (this.mLoggerName == null) {
                    iw2.println("e.printStackTrace();");
                } else {
                    iw2.println("if ( " + this.mLoggerName + ".isLoggable( MLevel.FINE ) )");
                    iw2.upIndent();
                    iw2.println(this.mLoggerName + ".log( MLevel.FINE, \"Inconsistent clone() definitions between subclass and superclass! \", e );");
                    iw2.downIndent();
                }
                iw2.println("throw new RuntimeException(\"Inconsistent clone() definitions between subclass and superclass! \" + e);");
                iw2.downIndent();
                iw2.println("}");
            }
            iw2.downIndent();
            iw2.println("}");
        }
    }
}

