/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Comparator;

public final class BeangenUtils {
    public static final Comparator PROPERTY_COMPARATOR = new Comparator(){

        public int compare(Object a2, Object b2) {
            Property aa2 = (Property)a2;
            Property bb2 = (Property)b2;
            return String.CASE_INSENSITIVE_ORDER.compare(aa2.getName(), bb2.getName());
        }
    };

    public static String capitalize(String propName) {
        char c2 = propName.charAt(0);
        return Character.toUpperCase(c2) + propName.substring(1);
    }

    public static void writeExplicitDefaultConstructor(int ctor_modifiers, ClassInfo info, IndentedWriter iw2) throws IOException {
        iw2.print(CodegenUtils.getModifierString(ctor_modifiers));
        iw2.println(' ' + info.getClassName() + "()");
        iw2.println("{}");
    }

    public static void writeArgList(Property[] props, boolean declare_types, IndentedWriter iw2) throws IOException {
        int len = props.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 != 0) {
                iw2.print(", ");
            }
            if (declare_types) {
                iw2.print(props[i2].getSimpleTypeName() + ' ');
            }
            iw2.print(props[i2].getName());
        }
    }

    public static void writePropertyMember(Property prop, IndentedWriter iw2) throws IOException {
        BeangenUtils.writePropertyVariable(prop, iw2);
    }

    public static void writePropertyVariable(Property prop, IndentedWriter iw2) throws IOException {
        BeangenUtils.writePropertyVariable(prop, prop.getDefaultValueExpression(), iw2);
    }

    public static void writePropertyMember(Property prop, String defaultValueExpression, IndentedWriter iw2) throws IOException {
        BeangenUtils.writePropertyVariable(prop, defaultValueExpression, iw2);
    }

    public static void writePropertyVariable(Property prop, String defaultValueExpression, IndentedWriter iw2) throws IOException {
        iw2.print(CodegenUtils.getModifierString(prop.getVariableModifiers()));
        iw2.print(' ' + prop.getSimpleTypeName() + ' ' + prop.getName());
        String dflt = defaultValueExpression;
        if (dflt != null) {
            iw2.print(" = " + dflt);
        }
        iw2.println(';');
    }

    public static void writePropertyGetter(Property prop, IndentedWriter iw2) throws IOException {
        BeangenUtils.writePropertyGetter(prop, prop.getDefensiveCopyExpression(), iw2);
    }

    public static void writePropertyGetter(Property prop, String defensiveCopyExpression, IndentedWriter iw2) throws IOException {
        String pfx = "boolean".equals(prop.getSimpleTypeName()) ? "is" : "get";
        iw2.print(CodegenUtils.getModifierString(prop.getGetterModifiers()));
        iw2.println(' ' + prop.getSimpleTypeName() + ' ' + pfx + BeangenUtils.capitalize(prop.getName()) + "()");
        String retVal = defensiveCopyExpression;
        if (retVal == null) {
            retVal = prop.getName();
        }
        iw2.println("{ return " + retVal + "; }");
    }

    public static void writePropertySetter(Property prop, IndentedWriter iw2) throws IOException {
        BeangenUtils.writePropertySetter(prop, prop.getDefensiveCopyExpression(), iw2);
    }

    public static void writePropertySetter(Property prop, String setterDefensiveCopyExpression, IndentedWriter iw2) throws IOException {
        String setVal = setterDefensiveCopyExpression;
        if (setVal == null) {
            setVal = prop.getName();
        }
        String usualGetExpression = "this." + prop.getName();
        String usualSetStatement = "this." + prop.getName() + " = " + setVal + ';';
        BeangenUtils.writePropertySetterWithGetExpressionSetStatement(prop, usualGetExpression, usualSetStatement, iw2);
    }

    public static void writePropertySetterWithGetExpressionSetStatement(Property prop, String getExpression, String setStatement, IndentedWriter iw2) throws IOException {
        iw2.print(CodegenUtils.getModifierString(prop.getSetterModifiers()));
        iw2.print(" void set" + BeangenUtils.capitalize(prop.getName()) + "( " + prop.getSimpleTypeName() + ' ' + prop.getName() + " )");
        if (prop.isConstrained()) {
            iw2.println(" throws PropertyVetoException");
        } else {
            iw2.println();
        }
        iw2.println('{');
        iw2.upIndent();
        if (BeangenUtils.changeMarked(prop)) {
            String changeCheck;
            iw2.println(prop.getSimpleTypeName() + " oldVal = " + getExpression + ';');
            String oldValExpr = "oldVal";
            String newValExpr = prop.getName();
            String simpleTypeName = prop.getSimpleTypeName();
            if (ClassUtils.isPrimitive(simpleTypeName)) {
                Class propType = ClassUtils.classForPrimitive(simpleTypeName);
                if (propType == Byte.TYPE) {
                    oldValExpr = "new Byte( " + oldValExpr + " )";
                    newValExpr = "new Byte( " + newValExpr + " )";
                } else if (propType == Character.TYPE) {
                    oldValExpr = "new Character( " + oldValExpr + " )";
                    newValExpr = "new Character( " + newValExpr + " )";
                } else if (propType == Short.TYPE) {
                    oldValExpr = "new Short( " + oldValExpr + " )";
                    newValExpr = "new Short( " + newValExpr + " )";
                } else if (propType == Float.TYPE) {
                    oldValExpr = "new Float( " + oldValExpr + " )";
                    newValExpr = "new Float( " + newValExpr + " )";
                } else if (propType == Double.TYPE) {
                    oldValExpr = "new Double( " + oldValExpr + " )";
                    newValExpr = "new Double( " + newValExpr + " )";
                }
                changeCheck = "oldVal != " + prop.getName();
            } else {
                changeCheck = "! eqOrBothNull( oldVal, " + prop.getName() + " )";
            }
            if (prop.isConstrained()) {
                iw2.println("if ( " + changeCheck + " )");
                iw2.upIndent();
                iw2.println("vcs.fireVetoableChange( \"" + prop.getName() + "\", " + oldValExpr + ", " + newValExpr + " );");
                iw2.downIndent();
            }
            iw2.println(setStatement);
            if (prop.isBound()) {
                iw2.println("if ( " + changeCheck + " )");
                iw2.upIndent();
                iw2.println("pcs.firePropertyChange( \"" + prop.getName() + "\", " + oldValExpr + ", " + newValExpr + " );");
                iw2.downIndent();
            }
        } else {
            iw2.println(setStatement);
        }
        iw2.downIndent();
        iw2.println('}');
    }

    public static boolean hasBoundProperties(Property[] props) {
        int len = props.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!props[i2].isBound()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConstrainedProperties(Property[] props) {
        int len = props.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!props[i2].isConstrained()) continue;
            return true;
        }
        return false;
    }

    private static boolean changeMarked(Property prop) {
        return prop.isBound() || prop.isConstrained();
    }

    private BeangenUtils() {
    }
}

