/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.BeangenUtils;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class BeanExtractingGeneratorExtension
implements GeneratorExtension {
    int ctor_modifiers = 1;
    int method_modifiers = 2;

    public void setConstructorModifiers(int ctor_modifiers) {
        this.ctor_modifiers = ctor_modifiers;
    }

    public int getConstructorModifiers() {
        return this.ctor_modifiers;
    }

    public void setExtractMethodModifiers(int ctor_modifiers) {
        this.method_modifiers = this.method_modifiers;
    }

    public int getExtractMethodModifiers() {
        return this.method_modifiers;
    }

    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraSpecificImports() {
        HashSet<String> set = new HashSet<String>();
        set.add("java.beans.BeanInfo");
        set.add("java.beans.PropertyDescriptor");
        set.add("java.beans.Introspector");
        set.add("java.beans.IntrospectionException");
        set.add("java.lang.reflect.InvocationTargetException");
        return set;
    }

    public Collection extraInterfaceNames() {
        return Collections.EMPTY_SET;
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw2) throws IOException {
        iw2.println("private static Class[] NOARGS = new Class[0];");
        iw2.println();
        iw2.print(CodegenUtils.getModifierString(this.method_modifiers));
        iw2.print(" void extractPropertiesFromBean( Object bean ) throws InvocationTargetException, IllegalAccessException, IntrospectionException");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("BeanInfo bi = Introspector.getBeanInfo( bean.getClass() );");
        iw2.println("PropertyDescriptor[] pds = bi.getPropertyDescriptors();");
        iw2.println("for (int i = 0, len = pds.length; i < len; ++i)");
        iw2.println("{");
        iw2.upIndent();
        int len = props.length;
        for (int i2 = 0; i2 < len; ++i2) {
            iw2.println("if (\"" + props[i2].getName() + "\".equals( pds[i].getName() ) )");
            iw2.upIndent();
            iw2.println("this." + props[i2].getName() + " = " + this.extractorExpr(props[i2], propTypes[i2]) + ';');
            iw2.downIndent();
        }
        iw2.println("}");
        iw2.downIndent();
        iw2.println("}");
        iw2.println();
        iw2.print(CodegenUtils.getModifierString(this.ctor_modifiers));
        iw2.println(' ' + info.getClassName() + "( Object bean ) throws InvocationTargetException, IllegalAccessException, IntrospectionException");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("extractPropertiesFromBean( bean );");
        iw2.downIndent();
        iw2.println("}");
    }

    private String extractorExpr(Property prop, Class propType) {
        if (propType.isPrimitive()) {
            String castType = BeangenUtils.capitalize(prop.getSimpleTypeName());
            String valueMethod = prop.getSimpleTypeName() + "Value()";
            if (propType == Character.TYPE) {
                castType = "Character";
            } else if (propType == Integer.TYPE) {
                castType = "Integer";
            }
            return "((" + castType + ") pds[i].getReadMethod().invoke( bean, NOARGS ))." + valueMethod;
        }
        return "(" + prop.getSimpleTypeName() + ") pds[i].getReadMethod().invoke( bean, NOARGS )";
    }
}

