/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.IndentedWriter;
import java.io.File;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class CodegenUtils {
    public static String getModifierString(int modifiers) {
        StringBuffer sb = new StringBuffer(32);
        if (Modifier.isPublic(modifiers)) {
            sb.append("public ");
        }
        if (Modifier.isProtected(modifiers)) {
            sb.append("protected ");
        }
        if (Modifier.isPrivate(modifiers)) {
            sb.append("private ");
        }
        if (Modifier.isAbstract(modifiers)) {
            sb.append("abstract ");
        }
        if (Modifier.isStatic(modifiers)) {
            sb.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            sb.append("final ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            sb.append("synchronized ");
        }
        if (Modifier.isTransient(modifiers)) {
            sb.append("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            sb.append("volatile ");
        }
        if (Modifier.isStrict(modifiers)) {
            sb.append("strictfp ");
        }
        if (Modifier.isNative(modifiers)) {
            sb.append("native ");
        }
        if (Modifier.isInterface(modifiers)) {
            sb.append("interface ");
        }
        return sb.toString().trim();
    }

    public static Class unarrayClass(Class cl2) {
        Class<?> out = cl2;
        while (out.isArray()) {
            out = out.getComponentType();
        }
        return out;
    }

    public static boolean inSamePackage(String cn1, String cn2) {
        int pkgdot = cn1.lastIndexOf(46);
        int pkgdot2 = cn2.lastIndexOf(46);
        if (pkgdot < 0 || pkgdot2 < 0) {
            return true;
        }
        if (cn1.substring(0, pkgdot).equals(cn1.substring(0, pkgdot))) {
            return cn2.indexOf(46) < 0;
        }
        return false;
    }

    public static String fqcnLastElement(String fqcn) {
        return ClassUtils.fqcnLastElement(fqcn);
    }

    public static String methodSignature(Method m2) {
        return CodegenUtils.methodSignature(m2, null);
    }

    public static String methodSignature(Method m2, String[] argNames) {
        return CodegenUtils.methodSignature(1, m2, argNames);
    }

    public static String methodSignature(int modifiers, Method m2, String[] argNames) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(CodegenUtils.getModifierString(modifiers));
        sb.append(' ');
        sb.append(ClassUtils.simpleClassName(m2.getReturnType()));
        sb.append(' ');
        sb.append(m2.getName());
        sb.append('(');
        Class<?>[] cls = m2.getParameterTypes();
        int len = cls.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(ClassUtils.simpleClassName(cls[i2]));
            sb.append(' ');
            sb.append(argNames == null ? String.valueOf((char)(97 + i2)) : argNames[i2]);
        }
        sb.append(')');
        Class<?>[] excClasses = m2.getExceptionTypes();
        if (excClasses.length > 0) {
            sb.append(" throws ");
            int len2 = excClasses.length;
            for (int i3 = 0; i3 < len2; ++i3) {
                if (i3 != 0) {
                    sb.append(", ");
                }
                sb.append(ClassUtils.simpleClassName(excClasses[i3]));
            }
        }
        return sb.toString();
    }

    public static String methodCall(Method m2) {
        return CodegenUtils.methodCall(m2, null);
    }

    public static String methodCall(Method m2, String[] argNames) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(m2.getName());
        sb.append('(');
        Class<?>[] cls = m2.getParameterTypes();
        int len = cls.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(argNames == null ? CodegenUtils.generatedArgumentName(i2) : argNames[i2]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String generatedArgumentName(int index) {
        return String.valueOf((char)(97 + index));
    }

    public static String simpleClassName(Class cl2) {
        return ClassUtils.simpleClassName(cl2);
    }

    public static IndentedWriter toIndentedWriter(Writer w2) {
        return w2 instanceof IndentedWriter ? (IndentedWriter)w2 : new IndentedWriter(w2);
    }

    public static String packageNameToFileSystemDirPath(String packageName) {
        StringBuffer sb = new StringBuffer(packageName);
        int len = sb.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (sb.charAt(i2) != '.') continue;
            sb.setCharAt(i2, File.separatorChar);
        }
        sb.append(File.separatorChar);
        return sb.toString();
    }

    private CodegenUtils() {
    }
}

