/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.BasicMultiPropertiesConfig;
import com.mchange.v2.cfg.CombinedMultiPropertiesConfig;
import com.mchange.v2.log.MLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;

public abstract class MultiPropertiesConfig {
    static final MultiPropertiesConfig EMPTY = new BasicMultiPropertiesConfig(new String[0]);
    static final String VM_CONFIG_RSRC_PATHS = "/com/mchange/v2/cfg/vmConfigResourcePaths.txt";
    static MultiPropertiesConfig vmConfig = null;

    public static MultiPropertiesConfig read(String[] resourcePath, MLogger logger) {
        return new BasicMultiPropertiesConfig(resourcePath, logger);
    }

    public static MultiPropertiesConfig read(String[] resourcePath) {
        return new BasicMultiPropertiesConfig(resourcePath);
    }

    public static MultiPropertiesConfig combine(MultiPropertiesConfig[] configs) {
        return new CombinedMultiPropertiesConfig(configs);
    }

    public static MultiPropertiesConfig readVmConfig(String[] defaultResources, String[] preemptingResources) {
        LinkedList<MultiPropertiesConfig> l2 = new LinkedList<MultiPropertiesConfig>();
        if (defaultResources != null) {
            l2.add(MultiPropertiesConfig.read(defaultResources));
        }
        l2.add(MultiPropertiesConfig.readVmConfig());
        if (preemptingResources != null) {
            l2.add(MultiPropertiesConfig.read(preemptingResources));
        }
        return MultiPropertiesConfig.combine(l2.toArray(new MultiPropertiesConfig[l2.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiPropertiesConfig readVmConfig() {
        if (vmConfig == null) {
            ArrayList<String> rps = new ArrayList<String>();
            BufferedReader br2 = null;
            try {
                InputStream is2 = MultiPropertiesConfig.class.getResourceAsStream(VM_CONFIG_RSRC_PATHS);
                if (is2 != null) {
                    String rp;
                    br2 = new BufferedReader(new InputStreamReader(is2, "8859_1"));
                    while ((rp = br2.readLine()) != null) {
                        if ("".equals(rp = rp.trim()) || rp.startsWith("#")) continue;
                        rps.add(rp);
                    }
                    vmConfig = new BasicMultiPropertiesConfig(rps.toArray(new String[rps.size()]));
                } else {
                    System.err.println("com.mchange.v2.cfg.MultiPropertiesConfig: Resource path list could not be found at resource path: /com/mchange/v2/cfg/vmConfigResourcePaths.txt");
                    System.err.println("com.mchange.v2.cfg.MultiPropertiesConfig: Using empty vmconfig.");
                    vmConfig = EMPTY;
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                try {
                    if (br2 != null) {
                        br2.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        return vmConfig;
    }

    public boolean foundVmConfig() {
        return vmConfig != EMPTY;
    }

    public abstract String[] getPropertiesResourcePaths();

    public abstract Properties getPropertiesByResourcePath(String var1);

    public abstract Properties getPropertiesByPrefix(String var1);

    public abstract String getProperty(String var1);
}

