/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.MultiPropertiesConfig;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

class CombinedMultiPropertiesConfig
extends MultiPropertiesConfig {
    MultiPropertiesConfig[] configs;
    String[] resourcePaths;

    CombinedMultiPropertiesConfig(MultiPropertiesConfig[] configs) {
        this.configs = configs;
        LinkedList<String> allPaths = new LinkedList<String>();
        for (int i2 = configs.length - 1; i2 >= 0; --i2) {
            String[] rps = configs[i2].getPropertiesResourcePaths();
            for (int j2 = rps.length - 1; j2 >= 0; --j2) {
                String rp = rps[j2];
                if (allPaths.contains(rp)) continue;
                allPaths.add(0, rp);
            }
        }
        this.resourcePaths = allPaths.toArray(new String[allPaths.size()]);
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.resourcePaths.clone();
    }

    public Properties getPropertiesByResourcePath(String path) {
        for (int i2 = this.configs.length - 1; i2 >= 0; --i2) {
            MultiPropertiesConfig config = this.configs[i2];
            Properties check = config.getPropertiesByResourcePath(path);
            if (check == null) continue;
            return check;
        }
        return null;
    }

    public Properties getPropertiesByPrefix(String pfx) {
        LinkedList<Map.Entry<Object, Object>> entries = new LinkedList<Map.Entry<Object, Object>>();
        for (int i2 = this.configs.length - 1; i2 >= 0; --i2) {
            MultiPropertiesConfig config = this.configs[i2];
            Properties check = config.getPropertiesByPrefix(pfx);
            if (check == null) continue;
            entries.addAll(0, check.entrySet());
        }
        if (entries.size() == 0) {
            return null;
        }
        Properties out = new Properties();
        Iterator ii2 = entries.iterator();
        while (ii2.hasNext()) {
            Map.Entry entry = (Map.Entry)ii2.next();
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public String getProperty(String key) {
        for (int i2 = this.configs.length - 1; i2 >= 0; --i2) {
            MultiPropertiesConfig config = this.configs[i2];
            String check = config.getProperty(key);
            if (check == null) continue;
            return check;
        }
        return null;
    }
}

