/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.stmt;

import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.c3p0.stmt.StatementCacheKey;
import com.mchange.v2.io.IndentedWriter;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.util.ResourceClosedException;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class GooGooStatementCache {
    private static final MLogger logger = MLog.getLogger(GooGooStatementCache.class);
    private static final int DESTROY_NEVER = 0;
    private static final int DESTROY_IF_CHECKED_IN = 1;
    private static final int DESTROY_IF_CHECKED_OUT = 2;
    private static final int DESTROY_ALWAYS = 3;
    ConnectionStatementManager cxnStmtMgr;
    HashMap stmtToKey = new HashMap();
    HashMap keyToKeyRec = new HashMap();
    HashSet checkedOut = new HashSet();
    AsynchronousRunner blockingTaskAsyncRunner;
    HashSet removalPending = new HashSet();

    public GooGooStatementCache(AsynchronousRunner blockingTaskAsyncRunner) {
        this.blockingTaskAsyncRunner = blockingTaskAsyncRunner;
        this.cxnStmtMgr = this.createConnectionStatementManager();
    }

    public synchronized int getNumStatements() {
        return this.isClosed() ? -1 : this.countCachedStatements();
    }

    public synchronized int getNumStatementsCheckedOut() {
        return this.isClosed() ? -1 : this.checkedOut.size();
    }

    public synchronized int getNumConnectionsWithCachedStatements() {
        return this.isClosed() ? -1 : this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
    }

    public synchronized String dumpStatementCacheStatus() {
        if (this.isClosed()) {
            return this + "status: Closed.";
        }
        StringWriter sw = new StringWriter(2048);
        IndentedWriter iw2 = new IndentedWriter(sw);
        try {
            iw2.print(this);
            iw2.println(" status:");
            iw2.upIndent();
            iw2.println("core stats:");
            iw2.upIndent();
            iw2.print("num cached statements: ");
            iw2.println(this.countCachedStatements());
            iw2.print("num cached statements in use: ");
            iw2.println(this.checkedOut.size());
            iw2.print("num connections with cached statements: ");
            iw2.println(this.cxnStmtMgr.getNumConnectionsWithCachedStatements());
            iw2.downIndent();
            iw2.println("cached statement dump:");
            iw2.upIndent();
            Iterator ii2 = this.cxnStmtMgr.connectionSet().iterator();
            while (ii2.hasNext()) {
                Connection pcon = (Connection)ii2.next();
                iw2.print(pcon);
                iw2.println(':');
                iw2.upIndent();
                Iterator jj2 = this.cxnStmtMgr.statementSet(pcon).iterator();
                while (jj2.hasNext()) {
                    iw2.println(jj2.next());
                }
                iw2.downIndent();
            }
            iw2.downIndent();
            iw2.downIndent();
            return sw.toString();
        }
        catch (IOException e2) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Huh? We've seen an IOException writing to s StringWriter?!", e2);
            }
            return e2.toString();
        }
    }

    abstract ConnectionStatementManager createConnectionStatementManager();

    public synchronized Object checkoutStatement(Connection physicalConnection, Method stmtProducingMethod, Object[] args) throws SQLException, ResourceClosedException {
        try {
            Object out = null;
            StatementCacheKey key = StatementCacheKey.find(physicalConnection, stmtProducingMethod, args);
            LinkedList l2 = this.checkoutQueue(key);
            if (l2 == null || l2.isEmpty()) {
                out = this.acquireStatement(physicalConnection, stmtProducingMethod, args);
                if (this.prepareAssimilateNewStatement(physicalConnection)) {
                    this.assimilateNewCheckedOutStatement(key, physicalConnection, out);
                }
            } else {
                logger.finest(this.getClass().getName() + " ----> CACHE HIT");
                out = l2.get(0);
                l2.remove(0);
                if (!this.checkedOut.add(out)) {
                    throw new RuntimeException("Internal inconsistency: Checking out a statement marked as already checked out!");
                }
                this.removeStatementFromDeathmarches(out, physicalConnection);
            }
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("checkoutStatement: " + this.statsString());
            }
            return out;
        }
        catch (NullPointerException npe) {
            if (this.checkedOut == null) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "A client attempted to work with a closed Statement cache, provoking a NullPointerException. c3p0 recovers, but this should be rare.", npe);
                }
                throw new ResourceClosedException(npe);
            }
            throw npe;
        }
    }

    public synchronized void checkinStatement(Object pstmt) throws SQLException {
        if (this.checkedOut == null) {
            this.synchronousDestroyStatement(pstmt);
            return;
        }
        if (!this.checkedOut.remove(pstmt)) {
            if (!this.ourResource(pstmt)) {
                this.destroyStatement(pstmt);
            }
            return;
        }
        try {
            this.refreshStatement((PreparedStatement)pstmt);
        }
        catch (Exception e2) {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.log(MLevel.INFO, "Problem with checked-in Statement, discarding.", e2);
            }
            this.checkedOut.add(pstmt);
            this.removeStatement(pstmt, 3);
            return;
        }
        StatementCacheKey key = (StatementCacheKey)this.stmtToKey.get(pstmt);
        if (key == null) {
            throw new RuntimeException("Internal inconsistency: A checked-out statement has no key associated with it!");
        }
        LinkedList l2 = this.checkoutQueue(key);
        l2.add(pstmt);
        this.addStatementToDeathmarches(pstmt, key.physicalConnection);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("checkinStatement(): " + this.statsString());
        }
    }

    public synchronized void checkinAll(Connection pcon) throws SQLException {
        Set stmtSet = this.cxnStmtMgr.statementSet(pcon);
        if (stmtSet != null) {
            Iterator ii2 = stmtSet.iterator();
            while (ii2.hasNext()) {
                Object stmt = ii2.next();
                if (!this.checkedOut.contains(stmt)) continue;
                this.checkinStatement(stmt);
            }
        }
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, "checkinAll(): " + this.statsString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(Connection pcon) throws SQLException {
        if (!this.isClosed()) {
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.log(MLevel.FINEST, "ENTER METHOD: closeAll( " + pcon + " )! -- num_connections: " + this.cxnStmtMgr.getNumConnectionsWithCachedStatements());
            }
            HashSet stmtSet = null;
            GooGooStatementCache gooGooStatementCache = this;
            synchronized (gooGooStatementCache) {
                Set cSet = this.cxnStmtMgr.statementSet(pcon);
                if (cSet != null) {
                    stmtSet = new HashSet(cSet);
                    Iterator ii2 = stmtSet.iterator();
                    while (ii2.hasNext()) {
                        Object stmt = ii2.next();
                        this.removeStatement(stmt, 0);
                    }
                }
            }
            if (stmtSet != null) {
                Iterator ii3 = stmtSet.iterator();
                while (ii3.hasNext()) {
                    Object stmt = ii3.next();
                    this.synchronousDestroyStatement(stmt);
                }
            }
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("closeAll(): " + this.statsString());
            }
        }
    }

    public synchronized void close() throws SQLException {
        if (!this.isClosed()) {
            Iterator ii2 = this.stmtToKey.keySet().iterator();
            while (ii2.hasNext()) {
                this.synchronousDestroyStatement(ii2.next());
            }
            this.cxnStmtMgr = null;
            this.stmtToKey = null;
            this.keyToKeyRec = null;
            this.checkedOut = null;
        } else if (logger.isLoggable(MLevel.FINE)) {
            logger.log(MLevel.FINE, this + ": duplicate call to close() [not harmful! -- debug only!]", new Exception("DUPLICATE CLOSE DEBUG STACK TRACE."));
        }
    }

    public synchronized boolean isClosed() {
        return this.cxnStmtMgr == null;
    }

    private void destroyStatement(Object pstmt) {
        class StatementCloseTask
        implements Runnable {
            private final /* synthetic */ Object val$pstmt;

            StatementCloseTask(Object object) {
                this.val$pstmt = object;
            }

            public void run() {
                StatementUtils.attemptClose((PreparedStatement)this.val$pstmt);
            }
        }
        StatementCloseTask r2 = new StatementCloseTask(pstmt);
        this.blockingTaskAsyncRunner.postRunnable(r2);
    }

    private void synchronousDestroyStatement(Object pstmt) {
        StatementUtils.attemptClose((PreparedStatement)pstmt);
    }

    abstract boolean prepareAssimilateNewStatement(Connection var1);

    abstract void addStatementToDeathmarches(Object var1, Connection var2);

    abstract void removeStatementFromDeathmarches(Object var1, Connection var2);

    final int countCachedStatements() {
        return this.stmtToKey.size();
    }

    private void assimilateNewCheckedOutStatement(StatementCacheKey key, Connection pConn, Object ps) {
        this.stmtToKey.put(ps, key);
        HashSet ks = this.keySet(key);
        if (ks == null) {
            this.keyToKeyRec.put(key, new KeyRec());
        } else {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Multiply prepared statement! " + key.stmtText);
            }
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("(The same statement has already been prepared by this Connection, and that other instance has not yet been closed, so the statement pool has to prepare a second PreparedStatement object rather than reusing the previously-cached Statement. The new Statement will be cached, in case you frequently need multiple copies of this Statement.)");
            }
        }
        this.keySet(key).add(ps);
        this.cxnStmtMgr.addStatementForConnection(ps, pConn);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("cxnStmtMgr.statementSet( " + pConn + " ).size(): " + this.cxnStmtMgr.statementSet(pConn).size());
        }
        this.checkedOut.add(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStatement(Object ps, int destruction_policy) {
        boolean check;
        boolean checked_in;
        HashSet hashSet = this.removalPending;
        synchronized (hashSet) {
            if (this.removalPending.contains(ps)) {
                return;
            }
            this.removalPending.add(ps);
        }
        StatementCacheKey sck = (StatementCacheKey)this.stmtToKey.remove(ps);
        this.removeFromKeySet(sck, ps);
        Connection pConn = sck.physicalConnection;
        boolean bl2 = checked_in = !this.checkedOut.contains(ps);
        if (checked_in) {
            this.removeStatementFromDeathmarches(ps, pConn);
            this.removeFromCheckoutQueue(sck, ps);
            if ((destruction_policy & 1) != 0) {
                this.destroyStatement(ps);
            }
        } else {
            this.checkedOut.remove(ps);
            if ((destruction_policy & 2) != 0) {
                this.destroyStatement(ps);
            }
        }
        if (!(check = this.cxnStmtMgr.removeStatementForConnection(ps, pConn)) && logger.isLoggable(MLevel.WARNING)) {
            logger.log(MLevel.WARNING, this + " removed a statement that apparently wasn't in a statement set!!!", new Exception("LOG STACK TRACE"));
        }
        HashSet hashSet2 = this.removalPending;
        synchronized (hashSet2) {
            this.removalPending.remove(ps);
        }
    }

    private Object acquireStatement(Connection pConn, Method stmtProducingMethod, Object[] args) throws SQLException {
        try {
            Object[] outHolder = new Object[1];
            SQLException[] exceptionHolder = new SQLException[1];
            class StmtAcquireTask
            implements Runnable {
                private final /* synthetic */ Object[] val$outHolder;
                private final /* synthetic */ Method val$stmtProducingMethod;
                private final /* synthetic */ Connection val$pConn;
                private final /* synthetic */ Object[] val$args;
                private final /* synthetic */ SQLException[] val$exceptionHolder;

                StmtAcquireTask(Object[] objectArray, Method method, Connection connection, Object[] objectArray2, SQLException[] sQLExceptionArray) {
                    this.val$outHolder = objectArray;
                    this.val$stmtProducingMethod = method;
                    this.val$pConn = connection;
                    this.val$args = objectArray2;
                    this.val$exceptionHolder = sQLExceptionArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        this.val$outHolder[0] = this.val$stmtProducingMethod.invoke((Object)this.val$pConn, this.val$args);
                    }
                    catch (InvocationTargetException e2) {
                        Throwable targetException = e2.getTargetException();
                        this.val$exceptionHolder[0] = targetException instanceof SQLException ? (SQLException)targetException : SqlUtils.toSQLException(targetException);
                    }
                    catch (Exception e3) {
                        this.val$exceptionHolder[0] = SqlUtils.toSQLException(e3);
                    }
                    finally {
                        GooGooStatementCache e2 = GooGooStatementCache.this;
                        synchronized (e2) {
                            GooGooStatementCache.this.notifyAll();
                        }
                    }
                }
            }
            StmtAcquireTask r2 = new StmtAcquireTask(outHolder, stmtProducingMethod, pConn, args, exceptionHolder);
            this.blockingTaskAsyncRunner.postRunnable(r2);
            while (outHolder[0] == null && exceptionHolder[0] == null) {
                this.wait();
            }
            if (exceptionHolder[0] != null) {
                throw exceptionHolder[0];
            }
            Object out = outHolder[0];
            return out;
        }
        catch (InterruptedException e2) {
            throw SqlUtils.toSQLException(e2);
        }
    }

    private KeyRec keyRec(StatementCacheKey key) {
        return (KeyRec)this.keyToKeyRec.get(key);
    }

    private HashSet keySet(StatementCacheKey key) {
        KeyRec rec = this.keyRec(key);
        return rec == null ? null : rec.allStmts;
    }

    private boolean removeFromKeySet(StatementCacheKey key, Object pstmt) {
        HashSet stmtSet = this.keySet(key);
        boolean out = stmtSet.remove(pstmt);
        if (stmtSet.isEmpty() && this.checkoutQueue(key).isEmpty()) {
            this.keyToKeyRec.remove(key);
        }
        return out;
    }

    private LinkedList checkoutQueue(StatementCacheKey key) {
        KeyRec rec = this.keyRec(key);
        return rec == null ? null : rec.checkoutQueue;
    }

    private boolean removeFromCheckoutQueue(StatementCacheKey key, Object pstmt) {
        LinkedList q2 = this.checkoutQueue(key);
        boolean out = q2.remove(pstmt);
        if (q2.isEmpty() && this.keySet(key).isEmpty()) {
            this.keyToKeyRec.remove(key);
        }
        return out;
    }

    private boolean ourResource(Object ps) {
        return this.stmtToKey.keySet().contains(ps);
    }

    private void refreshStatement(PreparedStatement ps) throws Exception {
        ps.clearParameters();
    }

    private void printStats() {
        int total_size = this.countCachedStatements();
        int checked_out_size = this.checkedOut.size();
        int num_connections = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int num_keys = this.keyToKeyRec.size();
        System.err.print(this.getClass().getName() + " stats -- ");
        System.err.print("total size: " + total_size);
        System.err.print("; checked out: " + checked_out_size);
        System.err.print("; num connections: " + num_connections);
        System.err.println("; num keys: " + num_keys);
    }

    private String statsString() {
        int total_size = this.countCachedStatements();
        int checked_out_size = this.checkedOut.size();
        int num_connections = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int num_keys = this.keyToKeyRec.size();
        StringBuffer sb = new StringBuffer(255);
        sb.append(this.getClass().getName());
        sb.append(" stats -- ");
        sb.append("total size: ");
        sb.append(total_size);
        sb.append("; checked out: ");
        sb.append(checked_out_size);
        sb.append("; num connections: ");
        sb.append(num_connections);
        sb.append("; num keys: ");
        sb.append(num_keys);
        return sb.toString();
    }

    protected final class DeathmarchConnectionStatementManager
    extends ConnectionStatementManager {
        Map cxnsToDms = new HashMap();

        protected DeathmarchConnectionStatementManager() {
        }

        public void addStatementForConnection(Object ps, Connection pcon) {
            super.addStatementForConnection(ps, pcon);
            Deathmarch dm2 = (Deathmarch)this.cxnsToDms.get(pcon);
            if (dm2 == null) {
                dm2 = new Deathmarch();
                this.cxnsToDms.put(pcon, dm2);
            }
        }

        public boolean removeStatementForConnection(Object ps, Connection pcon) {
            boolean out = super.removeStatementForConnection(ps, pcon);
            if (out && this.statementSet(pcon) == null) {
                this.cxnsToDms.remove(pcon);
            }
            return out;
        }

        public Deathmarch getDeathmarch(Connection pcon) {
            return (Deathmarch)this.cxnsToDms.get(pcon);
        }
    }

    protected static final class SimpleConnectionStatementManager
    extends ConnectionStatementManager {
        protected SimpleConnectionStatementManager() {
        }
    }

    protected static abstract class ConnectionStatementManager {
        Map cxnToStmtSets = new HashMap();

        protected ConnectionStatementManager() {
        }

        public int getNumConnectionsWithCachedStatements() {
            return this.cxnToStmtSets.size();
        }

        public Set connectionSet() {
            return this.cxnToStmtSets.keySet();
        }

        public Set statementSet(Connection pcon) {
            return (Set)this.cxnToStmtSets.get(pcon);
        }

        public int getNumStatementsForConnection(Connection pcon) {
            Set stmtSet = this.statementSet(pcon);
            return stmtSet == null ? 0 : stmtSet.size();
        }

        public void addStatementForConnection(Object ps, Connection pcon) {
            HashSet<Object> stmtSet = this.statementSet(pcon);
            if (stmtSet == null) {
                stmtSet = new HashSet<Object>();
                this.cxnToStmtSets.put(pcon, stmtSet);
            }
            stmtSet.add(ps);
        }

        public boolean removeStatementForConnection(Object ps, Connection pcon) {
            boolean out;
            Set stmtSet = this.statementSet(pcon);
            if (stmtSet != null) {
                out = stmtSet.remove(ps);
                if (stmtSet.isEmpty()) {
                    this.cxnToStmtSets.remove(pcon);
                }
            } else {
                out = false;
            }
            return out;
        }
    }

    protected class Deathmarch {
        TreeMap longsToStmts = new TreeMap();
        HashMap stmtsToLongs = new HashMap();
        long last_long = -1L;

        protected Deathmarch() {
        }

        public void deathmarchStatement(Object ps) {
            Long old = (Long)this.stmtsToLongs.get(ps);
            if (old != null) {
                throw new RuntimeException("Internal inconsistency: A statement is being double-deathmatched. no checked-out statements should be in a deathmarch already; no already checked-in statement should be deathmarched!");
            }
            Long youth = this.getNextLong();
            this.stmtsToLongs.put(ps, youth);
            this.longsToStmts.put(youth, ps);
        }

        public void undeathmarchStatement(Object ps) {
            Long old = (Long)this.stmtsToLongs.remove(ps);
            if (old == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
            Object check = this.longsToStmts.remove(old);
            if (old == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
        }

        public boolean cullNext() {
            if (this.longsToStmts.isEmpty()) {
                return false;
            }
            Long l2 = (Long)this.longsToStmts.firstKey();
            Object ps = this.longsToStmts.get(l2);
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("CULLING: " + ((StatementCacheKey)GooGooStatementCache.this.stmtToKey.get(ps)).stmtText);
            }
            GooGooStatementCache.this.removeStatement(ps, 3);
            if (this.contains(ps)) {
                throw new RuntimeException("Inconsistency!!! Statement culled from deathmarch failed to be removed by removeStatement( ... )!");
            }
            return true;
        }

        public boolean contains(Object ps) {
            return this.stmtsToLongs.keySet().contains(ps);
        }

        public int size() {
            return this.longsToStmts.size();
        }

        private Long getNextLong() {
            return new Long(++this.last_long);
        }
    }

    private static class KeyRec {
        HashSet allStmts = new HashSet();
        LinkedList checkoutQueue = new LinkedList();

        private KeyRec() {
        }
    }
}

