/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.AbstractConnectionTester;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultConnectionTester
extends AbstractConnectionTester {
    static final MLogger logger = MLog.getLogger(DefaultConnectionTester.class);
    static final int HASH_CODE = DefaultConnectionTester.class.getName().hashCode();
    static final Set INVALID_DB_STATES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int activeCheckConnection(Connection c2, String query, Throwable[] rootCauseOutParamHolder) {
        int n2;
        if (query == null) {
            return this.activeCheckConnectionNoQuery(c2, rootCauseOutParamHolder);
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c2.createStatement();
            rs = stmt.executeQuery(query);
            n2 = 0;
        }
        catch (SQLException e2) {
            block13: {
                String state;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Connection " + c2 + " failed Connection test with an Exception! [query=" + query + "]", e2);
                }
                if (rootCauseOutParamHolder != null) {
                    rootCauseOutParamHolder[0] = e2;
                }
                if (!INVALID_DB_STATES.contains(state = e2.getSQLState())) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception which occurred during a Connection test (test with query '" + query + "') implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", e2);
                }
                int n3 = -8;
                ResultSetUtils.attemptClose(rs);
                StatementUtils.attemptClose(stmt);
                return n3;
            }
            int n4 = -1;
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(stmt);
            return n4;
        }
        catch (Exception e3) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + c2 + " failed Connection test with an Exception!", e3);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = e3;
            }
            int n5 = -1;
            {
                catch (Throwable throwable) {
                    ResultSetUtils.attemptClose(rs);
                    StatementUtils.attemptClose(stmt);
                    throw throwable;
                }
            }
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(stmt);
            return n5;
        }
        ResultSetUtils.attemptClose(rs);
        StatementUtils.attemptClose(stmt);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int statusOnException(Connection c2, Throwable t2, String query, Throwable[] rootCauseOutParamHolder) {
        block12: {
            block13: {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Testing a Connection in response to an Exception:", t2);
                }
                if (!(t2 instanceof SQLException)) break block12;
                String state = ((SQLException)t2).getSQLState();
                if (!INVALID_DB_STATES.contains(state)) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception tested by statusOnException() implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", t2);
                }
                int n2 = -8;
                return n2;
            }
            int n3 = this.activeCheckConnection(c2, query, rootCauseOutParamHolder);
            return n3;
        }
        try {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection test failed because test-provoking Throwable is an unexpected, non-SQLException.", t2);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = t2;
            }
            int state = -1;
            return state;
        }
        catch (Exception e2) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + c2 + " failed Connection test with an Exception!", e2);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = e2;
            }
            int n4 = -1;
            return n4;
        }
    }

    private static String queryInfo(String query) {
        return query == null ? "[using default system-table query]" : "[query=" + query + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int activeCheckConnectionNoQuery(Connection c2, Throwable[] rootCauseOutParamHolder) {
        int n2;
        ResultSet rs = null;
        try {
            rs = c2.getMetaData().getTables(null, null, "PROBABLYNOT", new String[]{"TABLE"});
            n2 = 0;
        }
        catch (SQLException e2) {
            block12: {
                String state;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Connection " + c2 + " failed default system-table Connection test with an Exception!", e2);
                }
                if (rootCauseOutParamHolder != null) {
                    rootCauseOutParamHolder[0] = e2;
                }
                if (!INVALID_DB_STATES.contains(state = e2.getSQLState())) break block12;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception which occurred during a Connection test (fallback DatabaseMetaData test) implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", e2);
                }
                int n3 = -8;
                ResultSetUtils.attemptClose(rs);
                return n3;
            }
            int n4 = -1;
            ResultSetUtils.attemptClose(rs);
            return n4;
        }
        catch (Exception e3) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + c2 + " failed default system-table Connection test with an Exception!", e3);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = e3;
            }
            int n5 = -1;
            {
                catch (Throwable throwable) {
                    ResultSetUtils.attemptClose(rs);
                    throw throwable;
                }
            }
            ResultSetUtils.attemptClose(rs);
            return n5;
        }
        ResultSetUtils.attemptClose(rs);
        return n2;
    }

    public boolean equals(Object o2) {
        return o2 != null && o2.getClass() == DefaultConnectionTester.class;
    }

    public int hashCode() {
        return HASH_CODE;
    }

    static {
        HashSet<String> temp = new HashSet<String>();
        temp.add("08001");
        temp.add("08007");
        INVALID_DB_STATES = Collections.unmodifiableSet(temp);
    }
}

