/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPerTaskAsynchronousRunner;
import com.mchange.v2.io.IndentedWriter;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.ResourceClosedException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class ThreadPoolAsynchronousRunner
implements AsynchronousRunner {
    static final MLogger logger = MLog.getLogger(ThreadPoolAsynchronousRunner.class);
    static final int POLL_FOR_STOP_INTERVAL = 5000;
    static final int DFLT_DEADLOCK_DETECTOR_INTERVAL = 10000;
    static final int DFLT_INTERRUPT_DELAY_AFTER_APPARENT_DEADLOCK = 60000;
    static final int DFLT_MAX_INDIVIDUAL_TASK_TIME = 0;
    static final int DFLT_MAX_EMERGENCY_THREADS = 10;
    int deadlock_detector_interval;
    int interrupt_delay_after_apparent_deadlock;
    int max_individual_task_time;
    int num_threads;
    boolean daemon;
    HashSet managed;
    HashSet available;
    LinkedList pendingTasks;
    Timer myTimer;
    boolean should_cancel_timer;
    TimerTask deadlockDetector = new DeadlockDetector();
    TimerTask replacedThreadInterruptor = null;
    Map stoppedThreadsToStopDates = new HashMap();

    private ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, Timer myTimer, boolean should_cancel_timer) {
        this.num_threads = num_threads;
        this.daemon = daemon;
        this.max_individual_task_time = max_individual_task_time;
        this.deadlock_detector_interval = deadlock_detector_interval;
        this.interrupt_delay_after_apparent_deadlock = interrupt_delay_after_apparent_deadlock;
        this.myTimer = myTimer;
        this.should_cancel_timer = should_cancel_timer;
        this.recreateThreadsAndTasks();
        myTimer.schedule(this.deadlockDetector, deadlock_detector_interval, (long)deadlock_detector_interval);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, Timer myTimer) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, myTimer, false);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, new Timer(true), true);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, Timer sharedTimer) {
        this(num_threads, daemon, 0, 10000, 60000, sharedTimer, false);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon) {
        this(num_threads, daemon, 0, 10000, 60000, new Timer(true), true);
    }

    public synchronized void postRunnable(Runnable r2) {
        try {
            this.pendingTasks.add(r2);
            this.notifyAll();
        }
        catch (NullPointerException e2) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "NullPointerException while posting Runnable -- Probably we're closed.", e2);
            }
            throw new ResourceClosedException("Attempted to use a ThreadPoolAsynchronousRunner in a closed or broken state.");
        }
    }

    public synchronized int getThreadCount() {
        return this.managed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean skip_remaining_tasks) {
        ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = this;
        synchronized (threadPoolAsynchronousRunner) {
            if (this.managed == null) {
                return;
            }
            this.deadlockDetector.cancel();
            if (this.should_cancel_timer) {
                this.myTimer.cancel();
            }
            this.myTimer = null;
            Iterator ii2 = this.managed.iterator();
            while (ii2.hasNext()) {
                PoolThread stopMe = (PoolThread)ii2.next();
                stopMe.gentleStop();
                if (!skip_remaining_tasks) continue;
                stopMe.interrupt();
            }
            this.managed = null;
            if (!skip_remaining_tasks) {
                ii2 = this.pendingTasks.iterator();
                while (ii2.hasNext()) {
                    Runnable r2 = (Runnable)ii2.next();
                    new Thread(r2).start();
                    ii2.remove();
                }
            }
            this.available = null;
            this.pendingTasks = null;
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized int getActiveCount() {
        return this.managed.size() - this.available.size();
    }

    public synchronized int getIdleCount() {
        return this.available.size();
    }

    public synchronized int getPendingTaskCount() {
        return this.pendingTasks.size();
    }

    public synchronized String getStatus() {
        return this.getMultiLineStatusString();
    }

    public synchronized String getStackTraces() {
        return this.getStackTraces(0);
    }

    private String getStackTraces(int initial_indent) {
        if (this.managed == null) {
            return null;
        }
        try {
            Method m2 = Thread.class.getMethod("getStackTrace", null);
            StringWriter sw = new StringWriter(2048);
            IndentedWriter iw2 = new IndentedWriter(sw);
            for (int i2 = 0; i2 < initial_indent; ++i2) {
                iw2.upIndent();
            }
            Iterator ii2 = this.managed.iterator();
            while (ii2.hasNext()) {
                Object poolThread = ii2.next();
                Object[] stackTraces = (Object[])m2.invoke(poolThread, null);
                iw2.println(poolThread);
                iw2.upIndent();
                int len = stackTraces.length;
                for (int i3 = 0; i3 < len; ++i3) {
                    iw2.println(stackTraces[i3]);
                }
                iw2.downIndent();
            }
            for (int i4 = 0; i4 < initial_indent; ++i4) {
                iw2.downIndent();
            }
            iw2.flush();
            String out = sw.toString();
            iw2.close();
            return out;
        }
        catch (NoSuchMethodException e2) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine(this + ": strack traces unavailable because this is a pre-Java 1.5 VM.");
            }
            return null;
        }
        catch (Exception e3) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, this + ": An Exception occurred while trying to extract PoolThread stack traces.", e3);
            }
            return null;
        }
    }

    public synchronized String getMultiLineStatusString() {
        return this.getMultiLineStatusString(0);
    }

    private String getMultiLineStatusString(int initial_indent) {
        try {
            int i2;
            StringWriter sw = new StringWriter(2048);
            IndentedWriter iw2 = new IndentedWriter(sw);
            for (i2 = 0; i2 < initial_indent; ++i2) {
                iw2.upIndent();
            }
            if (this.managed == null) {
                iw2.print("[");
                iw2.print(this);
                iw2.println(" closed.]");
            } else {
                HashSet active = (HashSet)this.managed.clone();
                active.removeAll(this.available);
                iw2.print("Managed Threads: ");
                iw2.println(this.managed.size());
                iw2.print("Active Threads: ");
                iw2.println(active.size());
                iw2.println("Active Tasks: ");
                iw2.upIndent();
                Iterator ii2 = active.iterator();
                while (ii2.hasNext()) {
                    PoolThread pt = (PoolThread)ii2.next();
                    iw2.print(pt.getCurrentTask());
                    iw2.print(" (");
                    iw2.print(pt.getName());
                    iw2.println(')');
                }
                iw2.downIndent();
                iw2.println("Pending Tasks: ");
                iw2.upIndent();
                int len = this.pendingTasks.size();
                for (int i3 = 0; i3 < len; ++i3) {
                    iw2.println(this.pendingTasks.get(i3));
                }
                iw2.downIndent();
            }
            for (i2 = 0; i2 < initial_indent; ++i2) {
                iw2.downIndent();
            }
            iw2.flush();
            String out = sw.toString();
            iw2.close();
            return out;
        }
        catch (IOException e2) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Huh? An IOException when working with a StringWriter?!?", e2);
            }
            throw new RuntimeException("Huh? An IOException when working with a StringWriter?!? " + e2);
        }
    }

    private void appendStatusString(StringBuffer sb) {
        if (this.managed == null) {
            sb.append("[closed]");
        } else {
            HashSet active = (HashSet)this.managed.clone();
            active.removeAll(this.available);
            sb.append("[num_managed_threads: ");
            sb.append(this.managed.size());
            sb.append(", num_active: ");
            sb.append(active.size());
            sb.append("; activeTasks: ");
            boolean first = true;
            Iterator ii2 = active.iterator();
            while (ii2.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                PoolThread pt = (PoolThread)ii2.next();
                sb.append(pt.getCurrentTask());
                sb.append(" (");
                sb.append(pt.getName());
                sb.append(')');
            }
            sb.append("; pendingTasks: ");
            int len = this.pendingTasks.size();
            for (int i2 = 0; i2 < len; ++i2) {
                if (i2 != 0) {
                    sb.append(", ");
                }
                sb.append(this.pendingTasks.get(i2));
            }
            sb.append(']');
        }
    }

    private void recreateThreadsAndTasks() {
        if (this.managed != null) {
            Date aboutNow = new Date();
            Iterator ii2 = this.managed.iterator();
            while (ii2.hasNext()) {
                PoolThread pt = (PoolThread)ii2.next();
                pt.gentleStop();
                this.stoppedThreadsToStopDates.put(pt, aboutNow);
                this.ensureReplacedThreadsProcessing();
            }
        }
        this.managed = new HashSet();
        this.available = new HashSet();
        this.pendingTasks = new LinkedList();
        for (int i2 = 0; i2 < this.num_threads; ++i2) {
            PoolThread t2 = new PoolThread(i2, this.daemon);
            this.managed.add(t2);
            this.available.add(t2);
            t2.start();
        }
    }

    private void processReplacedThreads() {
        long about_now = System.currentTimeMillis();
        Iterator ii2 = this.stoppedThreadsToStopDates.keySet().iterator();
        while (ii2.hasNext()) {
            PoolThread pt = (PoolThread)ii2.next();
            if (!pt.isAlive()) {
                ii2.remove();
            } else {
                Date d2 = (Date)this.stoppedThreadsToStopDates.get(pt);
                if (about_now - d2.getTime() > (long)this.interrupt_delay_after_apparent_deadlock) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "Task " + pt.getCurrentTask() + " (in deadlocked PoolThread) failed to complete in maximum time " + this.interrupt_delay_after_apparent_deadlock + "ms. Trying interrupt().");
                    }
                    pt.interrupt();
                    ii2.remove();
                }
            }
            if (!this.stoppedThreadsToStopDates.isEmpty()) continue;
            this.stopReplacedThreadsProcessing();
        }
    }

    private void ensureReplacedThreadsProcessing() {
        if (this.replacedThreadInterruptor == null) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("Apparently some threads have been replaced. Replacement thread processing enabled.");
            }
            this.replacedThreadInterruptor = new ReplacedThreadInterruptor();
            int replacedThreadProcessDelay = this.interrupt_delay_after_apparent_deadlock / 4;
            this.myTimer.schedule(this.replacedThreadInterruptor, replacedThreadProcessDelay, (long)replacedThreadProcessDelay);
        }
    }

    private void stopReplacedThreadsProcessing() {
        if (this.replacedThreadInterruptor != null) {
            this.replacedThreadInterruptor.cancel();
            this.replacedThreadInterruptor = null;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("Apparently all replaced threads have either completed their tasks or been interrupted(). Replacement thread processing cancelled.");
            }
        }
    }

    private void shuttingDown(PoolThread pt) {
        if (this.managed != null && this.managed.contains(pt)) {
            this.managed.remove(pt);
            this.available.remove(pt);
            PoolThread replacement = new PoolThread(pt.getIndex(), this.daemon);
            this.managed.add(replacement);
            this.available.add(replacement);
            replacement.start();
        }
    }

    private void runInEmergencyThread(Runnable r2) {
        Thread t2 = new Thread(r2);
        t2.start();
        if (this.max_individual_task_time > 0) {
            MaxIndividualTaskTimeEnforcer maxIndividualTaskTimeEnforcer = new MaxIndividualTaskTimeEnforcer(t2, t2 + " [One-off emergency thread!!!]", r2.toString());
            this.myTimer.schedule((TimerTask)maxIndividualTaskTimeEnforcer, this.max_individual_task_time);
        }
    }

    class ReplacedThreadInterruptor
    extends TimerTask {
        ReplacedThreadInterruptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                ThreadPoolAsynchronousRunner.this.processReplacedThreads();
            }
        }
    }

    class MaxIndividualTaskTimeEnforcer
    extends TimerTask {
        PoolThread pt;
        Thread interruptMe;
        String threadStr;
        String fixedTaskStr;

        MaxIndividualTaskTimeEnforcer(PoolThread pt) {
            this.pt = pt;
            this.interruptMe = pt;
            this.threadStr = pt.toString();
            this.fixedTaskStr = null;
        }

        MaxIndividualTaskTimeEnforcer(Thread interruptMe, String threadStr, String fixedTaskStr) {
            this.pt = null;
            this.interruptMe = interruptMe;
            this.threadStr = threadStr;
            this.fixedTaskStr = fixedTaskStr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String taskStr;
            if (this.fixedTaskStr != null) {
                taskStr = this.fixedTaskStr;
            } else if (this.pt != null) {
                ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                synchronized (threadPoolAsynchronousRunner) {
                    taskStr = String.valueOf(this.pt.getCurrentTask());
                }
            } else {
                taskStr = "Unknown task?!";
            }
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("A task has exceeded the maximum allowable task time. Will interrupt() thread [" + this.threadStr + "], with current task: " + taskStr);
            }
            this.interruptMe.interrupt();
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Thread [" + this.threadStr + "] interrupted.");
            }
        }
    }

    class DeadlockDetector
    extends TimerTask {
        LinkedList last = null;
        LinkedList current = null;

        DeadlockDetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean run_stray_tasks = false;
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                if (ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                    this.last = null;
                    return;
                }
                this.current = (LinkedList)ThreadPoolAsynchronousRunner.this.pendingTasks.clone();
                if (this.current.equals(this.last)) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.warning(this + " -- APPARENT DEADLOCK!!! Creating emergency threads for unassigned pending tasks!");
                        StringWriter sw = new StringWriter(4096);
                        PrintWriter pw = new PrintWriter(sw);
                        pw.print(this);
                        pw.println(" -- APPARENT DEADLOCK!!! Complete Status: ");
                        pw.print(ThreadPoolAsynchronousRunner.this.getMultiLineStatusString(1));
                        pw.println("Pool thread stack traces:");
                        String stackTraces = ThreadPoolAsynchronousRunner.this.getStackTraces(1);
                        if (stackTraces == null) {
                            pw.println("\t[Stack traces of deadlocked task threads not available.]");
                        } else {
                            pw.println(stackTraces);
                        }
                        pw.flush();
                        logger.warning(sw.toString());
                        pw.close();
                    }
                    ThreadPoolAsynchronousRunner.this.recreateThreadsAndTasks();
                    run_stray_tasks = true;
                }
            }
            if (run_stray_tasks) {
                ThreadPerTaskAsynchronousRunner ar2 = new ThreadPerTaskAsynchronousRunner(10, ThreadPoolAsynchronousRunner.this.max_individual_task_time);
                Iterator ii2 = this.current.iterator();
                while (ii2.hasNext()) {
                    ar2.postRunnable((Runnable)ii2.next());
                }
                ar2.close(false);
                this.last = null;
            } else {
                this.last = this.current;
            }
            this.current = null;
        }
    }

    class PoolThread
    extends Thread {
        Runnable currentTask;
        boolean should_stop;
        int index;
        TimerTask maxIndividualTaskTimeEnforcer = null;

        PoolThread(int index, boolean daemon) {
            this.setName(this.getClass().getName() + "-#" + index);
            this.setDaemon(daemon);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        void gentleStop() {
            this.should_stop = true;
        }

        Runnable getCurrentTask() {
            return this.currentTask;
        }

        private void setMaxIndividualTaskTimeEnforcer() {
            this.maxIndividualTaskTimeEnforcer = new MaxIndividualTaskTimeEnforcer(this);
            ThreadPoolAsynchronousRunner.this.myTimer.schedule(this.maxIndividualTaskTimeEnforcer, ThreadPoolAsynchronousRunner.this.max_individual_task_time);
        }

        private void cancelMaxIndividualTaskTimeEnforcer() {
            this.maxIndividualTaskTimeEnforcer.cancel();
            this.maxIndividualTaskTimeEnforcer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Runnable myTask;
                    ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                    synchronized (threadPoolAsynchronousRunner) {
                        while (!this.should_stop && ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                            ThreadPoolAsynchronousRunner.this.wait(5000L);
                        }
                        if (this.should_stop) {
                            break;
                        }
                        if (!ThreadPoolAsynchronousRunner.this.available.remove(this)) {
                            throw new InternalError("An unavailable PoolThread tried to check itself out!!!");
                        }
                        this.currentTask = myTask = (Runnable)ThreadPoolAsynchronousRunner.this.pendingTasks.remove(0);
                    }
                    try {
                        if (ThreadPoolAsynchronousRunner.this.max_individual_task_time > 0) {
                            this.setMaxIndividualTaskTimeEnforcer();
                        }
                        myTask.run();
                    }
                    catch (RuntimeException e2) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, this + " -- caught unexpected Exception while executing posted task.", e2);
                    }
                    finally {
                        if (this.maxIndividualTaskTimeEnforcer != null) {
                            this.cancelMaxIndividualTaskTimeEnforcer();
                        }
                        threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                        synchronized (threadPoolAsynchronousRunner) {
                            if (this.should_stop) {
                                break;
                            }
                            if (ThreadPoolAsynchronousRunner.this.available != null && !ThreadPoolAsynchronousRunner.this.available.add(this)) {
                                throw new InternalError("An apparently available PoolThread tried to check itself in!!!");
                            }
                            this.currentTask = null;
                        }
                    }
                }
                catch (InterruptedException exc) {
                    if (!logger.isLoggable(MLevel.FINE)) break;
                    logger.fine(this + " interrupted. Shutting down.");
                    break;
                }
            }
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                ThreadPoolAsynchronousRunner.this.shuttingDown(this);
            }
        }
    }
}

