/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.io;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class InputStreamUtils {
    private static final MLogger logger = MLog.getLogger(InputStreamUtils.class);
    private static InputStream EMPTY_ISTREAM = new ByteArrayInputStream(new byte[0]);

    public static boolean compare(InputStream is1, InputStream is2, long num_bytes) throws IOException {
        for (long num_read = 0L; num_read < num_bytes; ++num_read) {
            int b2 = is1.read();
            if (b2 != is2.read()) {
                return false;
            }
            if (b2 < 0) break;
        }
        return true;
    }

    public static boolean compare(InputStream is1, InputStream is2) throws IOException {
        int b2 = 0;
        while (b2 >= 0) {
            b2 = is1.read();
            if (b2 == is2.read()) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(InputStream is2, int max_len) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(max_len);
        int b2 = is2.read();
        for (int i2 = 0; b2 >= 0 && i2 < max_len; ++i2) {
            baos.write(b2);
            b2 = is2.read();
        }
        return baos.toByteArray();
    }

    public static byte[] getBytes(InputStream is2) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b2 = is2.read();
        while (b2 >= 0) {
            baos.write(b2);
            b2 = is2.read();
        }
        return baos.toByteArray();
    }

    public static String getContentsAsString(InputStream is2, String enc) throws IOException, UnsupportedEncodingException {
        return new String(InputStreamUtils.getBytes(is2), enc);
    }

    public static String getContentsAsString(InputStream is2) throws IOException {
        try {
            return InputStreamUtils.getContentsAsString(is2, System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError("You have no default character encoding, and iso-8859-1 is unsupported?!?!");
        }
    }

    public static String getContentsAsString(InputStream is2, int max_len, String enc) throws IOException, UnsupportedEncodingException {
        return new String(InputStreamUtils.getBytes(is2, max_len), enc);
    }

    public static String getContentsAsString(InputStream is2, int max_len) throws IOException {
        try {
            return InputStreamUtils.getContentsAsString(is2, max_len, System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException e2) {
            throw new InternalError("You have no default character encoding, and iso-8859-1 is unsupported?!?!");
        }
    }

    public static InputStream getEmptyInputStream() {
        return EMPTY_ISTREAM;
    }

    public static void attemptClose(InputStream is2) {
        block3: {
            try {
                if (is2 != null) {
                    is2.close();
                }
            }
            catch (IOException e2) {
                if (!logger.isLoggable(MLevel.WARNING)) break block3;
                logger.log(MLevel.WARNING, "InputStream close FAILED.", e2);
            }
        }
    }

    public static void skipFully(InputStream is2, long num_bytes) throws EOFException, IOException {
        long num_skipped = 0L;
        while (num_skipped < num_bytes) {
            long just_skipped = is2.skip(num_bytes - num_skipped);
            if (just_skipped > 0L) {
                num_skipped += just_skipped;
                continue;
            }
            int test_byte = is2.read();
            if (is2.read() < 0) {
                throw new EOFException("Skipped only " + num_skipped + " bytes to end of file.");
            }
            ++num_skipped;
        }
    }

    private InputStreamUtils() {
    }
}

